/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.pagerank.PageRankAlgorithm;
import org.neo4j.gds.pagerank.PageRankAlgorithmFactory;
import org.neo4j.gds.pagerank.PageRankWriteConfig;
import org.neo4j.gds.pagerank.PageRankWriteProc;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.articleRank.write", description="Page Rank is an algorithm that measures the transitive influence or connectivity of nodes.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class ArticleRankWriteProc
extends PageRankWriteProc {
    @Override
    @Procedure(value="gds.articleRank.write", mode=Mode.WRITE)
    @Description(value="Page Rank is an algorithm that measures the transitive influence or connectivity of nodes.")
    public Stream<PageRankWriteProc.WriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return super.write(graphName, configuration);
    }

    @Override
    @Procedure(value="gds.articleRank.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return super.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    @Override
    public GraphAlgorithmFactory<PageRankAlgorithm, PageRankWriteConfig> algorithmFactory() {
        return new PageRankAlgorithmFactory(PageRankAlgorithmFactory.Mode.ARTICLE_RANK);
    }
}

