/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.pagerank.PageRankAlgorithm;
import org.neo4j.gds.pagerank.PageRankAlgorithmFactory;
import org.neo4j.gds.pagerank.PageRankMutateConfig;
import org.neo4j.gds.pagerank.PageRankProc;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.pagerank.PageRankStatsProc;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.pageRank.mutate", description="Page Rank is an algorithm that measures the transitive influence or connectivity of nodes.", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class PageRankMutateProc
extends MutatePropertyProc<PageRankAlgorithm, PageRankResult, MutateResult, PageRankMutateConfig> {
    @Procedure(value="gds.pageRank.mutate", mode=Mode.READ)
    @Description(value="Page Rank is an algorithm that measures the transitive influence or connectivity of nodes.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.mutate(computationResult);
    }

    @Procedure(value="gds.pageRank.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected PageRankMutateConfig newConfig(String username, CypherMapWrapper config) {
        return PageRankMutateConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<PageRankAlgorithm, PageRankMutateConfig> algorithmFactory() {
        return new PageRankAlgorithmFactory();
    }

    protected NodeProperties nodeProperties(ComputationResult<PageRankAlgorithm, PageRankResult, PageRankMutateConfig> computationResult) {
        return PageRankProc.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<PageRankAlgorithm, PageRankResult, PageRankMutateConfig> computeResult, ExecutionContext executionContext) {
        return PageRankProc.resultBuilder(new MutateResult.Builder(executionContext.callContext(), ((PageRankMutateConfig)computeResult.config()).concurrency()), computeResult);
    }

    public ValidationConfiguration<PageRankMutateConfig> validationConfig() {
        return PageRankProc.getValidationConfig(this.log);
    }

    public static final class MutateResult
    extends PageRankStatsProc.StatsResult {
        public final long mutateMillis;
        public final long nodePropertiesWritten;

        MutateResult(long ranIterations, boolean didConverge, @Nullable Map<String, Object> centralityDistribution, long preProcessingMillis, long computeMillis, long postProcessingMillis, long mutateMillis, long nodePropertiesWritten, Map<String, Object> configuration) {
            super(ranIterations, didConverge, centralityDistribution, preProcessingMillis, computeMillis, postProcessingMillis, configuration);
            this.mutateMillis = mutateMillis;
            this.nodePropertiesWritten = nodePropertiesWritten;
        }

        static class Builder
        extends PageRankProc.PageRankResultBuilder<MutateResult> {
            Builder(ProcedureCallContext context, int concurrency) {
                super(context, concurrency);
            }

            public MutateResult buildResult() {
                return new MutateResult(this.ranIterations, this.didConverge, this.centralityHistogram, this.preProcessingMillis, this.computeMillis, this.postProcessingMillis, this.mutateMillis, this.nodePropertiesWritten, this.config.toMap());
            }
        }
    }
}

