/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StatsProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.pagerank.PageRankAlgorithm;
import org.neo4j.gds.pagerank.PageRankAlgorithmFactory;
import org.neo4j.gds.pagerank.PageRankProc;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.pagerank.PageRankStatsConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardStatsResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.pageRank.stats", description="Executes the algorithm and returns result statistics without writing the result to Neo4j.", executionMode=ExecutionMode.STATS)
public class PageRankStatsProc
extends StatsProc<PageRankAlgorithm, PageRankResult, StatsResult, PageRankStatsConfig> {
    @Procedure(value="gds.pageRank.stats", mode=Mode.READ)
    @Description(value="Executes the algorithm and returns result statistics without writing the result to Neo4j.")
    public Stream<StatsResult> stats(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.stats(computationResult);
    }

    @Procedure(value="gds.pageRank.stats.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected AbstractResultBuilder<StatsResult> resultBuilder(ComputationResult<PageRankAlgorithm, PageRankResult, PageRankStatsConfig> computeResult, ExecutionContext executionContext) {
        return PageRankProc.resultBuilder(new StatsResult.Builder(this.callContext, ((PageRankStatsConfig)computeResult.config()).concurrency()), computeResult);
    }

    public ValidationConfiguration<PageRankStatsConfig> validationConfig() {
        return PageRankProc.getValidationConfig(this.log);
    }

    protected PageRankStatsConfig newConfig(String username, CypherMapWrapper config) {
        return PageRankStatsConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<PageRankAlgorithm, PageRankStatsConfig> algorithmFactory() {
        return new PageRankAlgorithmFactory();
    }

    public static class StatsResult
    extends StandardStatsResult {
        public final long ranIterations;
        public final boolean didConverge;
        public final Map<String, Object> centralityDistribution;

        StatsResult(long ranIterations, boolean didConverge, @Nullable Map<String, Object> centralityDistribution, long preProcessingMillis, long computeMillis, long postProcessingMillis, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, postProcessingMillis, configuration);
            this.ranIterations = ranIterations;
            this.didConverge = didConverge;
            this.centralityDistribution = centralityDistribution;
        }

        static class Builder
        extends PageRankProc.PageRankResultBuilder<StatsResult> {
            Builder(ProcedureCallContext context, int concurrency) {
                super(context, concurrency);
            }

            public StatsResult buildResult() {
                return new StatsResult(this.ranIterations, this.didConverge, this.centralityHistogram, this.preProcessingMillis, this.computeMillis, this.postProcessingMillis, this.config.toMap());
            }
        }
    }
}

