/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.WriteProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.pagerank.PageRankAlgorithm;
import org.neo4j.gds.pagerank.PageRankAlgorithmFactory;
import org.neo4j.gds.pagerank.PageRankProc;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.pagerank.PageRankStatsProc;
import org.neo4j.gds.pagerank.PageRankWriteConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.pageRank.write", description="Page Rank is an algorithm that measures the transitive influence or connectivity of nodes.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class PageRankWriteProc
extends WriteProc<PageRankAlgorithm, PageRankResult, WriteResult, PageRankWriteConfig> {
    @Procedure(value="gds.pageRank.write", mode=Mode.WRITE)
    @Description(value="Page Rank is an algorithm that measures the transitive influence or connectivity of nodes.")
    public Stream<WriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.write(computationResult);
    }

    @Procedure(value="gds.pageRank.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected NodeProperties nodeProperties(ComputationResult<PageRankAlgorithm, PageRankResult, PageRankWriteConfig> computationResult) {
        return PageRankProc.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<WriteResult> resultBuilder(ComputationResult<PageRankAlgorithm, PageRankResult, PageRankWriteConfig> computeResult, ExecutionContext executionContext) {
        return PageRankProc.resultBuilder(new WriteResult.Builder(this.callContext, ((PageRankWriteConfig)computeResult.config()).concurrency()), computeResult);
    }

    public GraphAlgorithmFactory<PageRankAlgorithm, PageRankWriteConfig> algorithmFactory() {
        return new PageRankAlgorithmFactory();
    }

    public ValidationConfiguration<PageRankWriteConfig> validationConfig() {
        return PageRankProc.getValidationConfig(this.log);
    }

    protected PageRankWriteConfig newConfig(String username, CypherMapWrapper config) {
        return PageRankWriteConfig.of((CypherMapWrapper)config);
    }

    public static final class WriteResult
    extends PageRankStatsProc.StatsResult {
        public final long writeMillis;
        public final long nodePropertiesWritten;

        WriteResult(long ranIterations, boolean didConverge, @Nullable Map<String, Object> centralityDistribution, long preProcessingMillis, long computeMillis, long postProcessingMillis, long writeMillis, long nodePropertiesWritten, Map<String, Object> configuration) {
            super(ranIterations, didConverge, centralityDistribution, preProcessingMillis, computeMillis, postProcessingMillis, configuration);
            this.writeMillis = writeMillis;
            this.nodePropertiesWritten = nodePropertiesWritten;
        }

        static class Builder
        extends PageRankProc.PageRankResultBuilder<WriteResult> {
            Builder(ProcedureCallContext context, int concurrency) {
                super(context, concurrency);
            }

            public WriteResult buildResult() {
                return new WriteResult(this.ranIterations, this.didConverge, this.centralityHistogram, this.preProcessingMillis, this.computeMillis, this.postProcessingMillis, this.writeMillis, this.nodePropertiesWritten, this.config.toMap());
            }
        }
    }
}

