/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StatsProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.betweenness.BetweennessCentrality;
import org.neo4j.gds.betweenness.BetweennessCentralityProc;
import org.neo4j.gds.betweenness.BetweennessCentralityStatsConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardStatsResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.betweenness.stats", description="Betweenness centrality measures the relative information flow that passes through a node.", executionMode=ExecutionMode.STATS)
public class BetweennessCentralityStatsProc
extends StatsProc<BetweennessCentrality, HugeAtomicDoubleArray, StatsResult, BetweennessCentralityStatsConfig> {
    @Procedure(value="gds.betweenness.stats", mode=Mode.READ)
    @Description(value="Betweenness centrality measures the relative information flow that passes through a node.")
    public Stream<StatsResult> stats(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stats(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.betweenness.stats.estimate", mode=Mode.READ)
    @Description(value="Betweenness centrality measures the relative information flow that passes through a node.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected BetweennessCentralityStatsConfig newConfig(String username, CypherMapWrapper config) {
        return BetweennessCentralityStatsConfig.of((CypherMapWrapper)config);
    }

    public ValidationConfiguration<BetweennessCentralityStatsConfig> validationConfig() {
        return BetweennessCentralityProc.getValidationConfig();
    }

    public GraphAlgorithmFactory<BetweennessCentrality, BetweennessCentralityStatsConfig> algorithmFactory() {
        return BetweennessCentralityProc.algorithmFactory();
    }

    protected NodePropertyValues nodeProperties(ComputationResult<BetweennessCentrality, HugeAtomicDoubleArray, BetweennessCentralityStatsConfig> computationResult) {
        return BetweennessCentralityProc.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<StatsResult> resultBuilder(ComputationResult<BetweennessCentrality, HugeAtomicDoubleArray, BetweennessCentralityStatsConfig> computeResult, ExecutionContext executionContext) {
        return BetweennessCentralityProc.resultBuilder(new StatsResult.Builder(this.callContext, ((BetweennessCentralityStatsConfig)computeResult.config()).concurrency()), computeResult);
    }

    public static class StatsResult
    extends StandardStatsResult {
        public final Map<String, Object> centralityDistribution;

        StatsResult(@Nullable Map<String, Object> centralityDistribution, long preProcessingMillis, long computeMillis, long postProcessingMillis, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, postProcessingMillis, configuration);
            this.centralityDistribution = centralityDistribution;
        }

        static final class Builder
        extends AbstractCentralityResultBuilder<StatsResult> {
            protected Builder(ProcedureCallContext callContext, int concurrency) {
                super(callContext, concurrency);
            }

            public StatsResult buildResult() {
                return new StatsResult(this.centralityHistogram, this.preProcessingMillis, this.computeMillis, this.postProcessingMillis, this.config.toMap());
            }
        }
    }
}

