/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.degree;

import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.properties.nodes.DoubleNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.degree.DegreeCentrality;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.degree.DegreeCentralityFactory;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;

public final class DegreeCentralityProc {
    static final String DEGREE_CENTRALITY_DESCRIPTION = "Degree centrality measures the number of incoming and outgoing relationships from a node.";

    private DegreeCentralityProc() {
    }

    static <CONFIG extends DegreeCentralityConfig> GraphAlgorithmFactory<DegreeCentrality, CONFIG> algorithmFactory() {
        return new DegreeCentralityFactory();
    }

    static <PROC_RESULT, CONFIG extends DegreeCentralityConfig> AbstractCentralityResultBuilder<PROC_RESULT> resultBuilder(AbstractCentralityResultBuilder<PROC_RESULT> procResultBuilder, ComputationResult<DegreeCentrality, DegreeCentrality.DegreeFunction, CONFIG> computeResult) {
        DegreeCentrality.DegreeFunction result = (DegreeCentrality.DegreeFunction)computeResult.result();
        procResultBuilder.withCentralityFunction(!computeResult.isGraphEmpty() ? arg_0 -> ((DegreeCentrality.DegreeFunction)result).get(arg_0) : null);
        return procResultBuilder;
    }

    static NodePropertyValues nodeProperties(ComputationResult<DegreeCentrality, DegreeCentrality.DegreeFunction, ? extends DegreeCentralityConfig> computationResult) {
        final long size = computationResult.graph().nodeCount();
        final DegreeCentrality.DegreeFunction degrees = (DegreeCentrality.DegreeFunction)computationResult.result();
        return new DoubleNodePropertyValues(){

            public long nodeCount() {
                return size;
            }

            public double doubleValue(long nodeId) {
                return degrees.get(nodeId);
            }
        };
    }
}

