/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.degree;

import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StatsProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.degree.DegreeCentrality;
import org.neo4j.gds.degree.DegreeCentralityFactory;
import org.neo4j.gds.degree.DegreeCentralityProc;
import org.neo4j.gds.degree.DegreeCentralityStatsConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardStatsResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.degree.stats", description="Degree centrality measures the number of incoming and outgoing relationships from a node.", executionMode=ExecutionMode.STATS)
public class DegreeCentralityStatsProc
extends StatsProc<DegreeCentrality, DegreeCentrality.DegreeFunction, StatsResult, DegreeCentralityStatsConfig> {
    @Procedure(value="gds.degree.stats", mode=Mode.READ)
    @Description(value="Degree centrality measures the number of incoming and outgoing relationships from a node.")
    public Stream<StatsResult> stats(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stats(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.degree.stats.estimate", mode=Mode.READ)
    @Description(value="Degree centrality measures the number of incoming and outgoing relationships from a node.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected DegreeCentralityStatsConfig newConfig(String username, CypherMapWrapper config) {
        return DegreeCentralityStatsConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<DegreeCentrality, DegreeCentralityStatsConfig> algorithmFactory() {
        return new DegreeCentralityFactory();
    }

    protected NodePropertyValues nodeProperties(ComputationResult<DegreeCentrality, DegreeCentrality.DegreeFunction, DegreeCentralityStatsConfig> computationResult) {
        return DegreeCentralityProc.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<StatsResult> resultBuilder(ComputationResult<DegreeCentrality, DegreeCentrality.DegreeFunction, DegreeCentralityStatsConfig> computeResult, ExecutionContext executionContext) {
        return DegreeCentralityProc.resultBuilder(new StatsResult.Builder(this.callContext, ((DegreeCentralityStatsConfig)computeResult.config()).concurrency()), computeResult);
    }

    public static class StatsResult
    extends StandardStatsResult {
        public final Map<String, Object> centralityDistribution;

        StatsResult(@Nullable Map<String, Object> centralityDistribution, long preProcessingMillis, long computeMillis, long postProcessingMillis, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, postProcessingMillis, configuration);
            this.centralityDistribution = centralityDistribution;
        }

        static final class Builder
        extends AbstractCentralityResultBuilder<StatsResult> {
            protected Builder(ProcedureCallContext callContext, int concurrency) {
                super(callContext, concurrency);
            }

            public StatsResult buildResult() {
                return new StatsResult(this.centralityHistogram, this.preProcessingMillis, this.computeMillis, this.postProcessingMillis, this.config.toMap());
            }
        }
    }
}

