/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.degree;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.common.CentralityStreamResult;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.degree.DegreeCentrality;
import org.neo4j.gds.degree.DegreeCentralityProc;
import org.neo4j.gds.degree.DegreeCentralityStreamConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.degree.stream", description="Degree centrality measures the number of incoming and outgoing relationships from a node.", executionMode=ExecutionMode.STREAM)
public class DegreeCentralityStreamProc
extends StreamProc<DegreeCentrality, DegreeCentrality.DegreeFunction, CentralityStreamResult, DegreeCentralityStreamConfig> {
    @Procedure(value="gds.degree.stream", mode=Mode.READ)
    @Description(value="Degree centrality measures the number of incoming and outgoing relationships from a node.")
    public Stream<CentralityStreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.degree.stream.estimate", mode=Mode.READ)
    @Description(value="Degree centrality measures the number of incoming and outgoing relationships from a node.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected DegreeCentralityStreamConfig newConfig(String username, CypherMapWrapper config) {
        return DegreeCentralityStreamConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<DegreeCentrality, DegreeCentralityStreamConfig> algorithmFactory() {
        return DegreeCentralityProc.algorithmFactory();
    }

    protected CentralityStreamResult streamResult(long originalNodeId, long internalNodeId, NodePropertyValues nodePropertyValues) {
        return new CentralityStreamResult(originalNodeId, nodePropertyValues.doubleValue(internalNodeId));
    }

    protected NodePropertyValues nodeProperties(ComputationResult<DegreeCentrality, DegreeCentrality.DegreeFunction, DegreeCentralityStreamConfig> computationResult) {
        return DegreeCentralityProc.nodeProperties(computationResult);
    }
}

