/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.pagerank.PageRankAlgorithm;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;

final class PageRankProc {
    static final String PAGE_RANK_DESCRIPTION = "Page Rank is an algorithm that measures the transitive influence or connectivity of nodes.";
    static final String ARTICLE_RANK_DESCRIPTION = "Article Rank is a variant of the Page Rank algorithm, which measures the transitive influence or connectivity of nodes.";
    static final String EIGENVECTOR_DESCRIPTION = "Eigenvector Centrality is an algorithm that measures the transitive influence or connectivity of nodes.";

    private PageRankProc() {
    }

    static <PROC_RESULT, CONFIG extends PageRankConfig> PageRankResultBuilder<PROC_RESULT> resultBuilder(PageRankResultBuilder<PROC_RESULT> procResultBuilder, ComputationResult<PageRankAlgorithm, PageRankResult, CONFIG> computeResult) {
        PageRankResult result = (PageRankResult)computeResult.result();
        procResultBuilder.withDidConverge(!computeResult.isGraphEmpty() && result.didConverge()).withRanIterations(!computeResult.isGraphEmpty() ? (long)result.iterations() : 0L).withCentralityFunction(!computeResult.isGraphEmpty() ? arg_0 -> ((HugeDoubleArray)((PageRankResult)computeResult.result()).scores()).get(arg_0) : null).withScalerVariant(((PageRankConfig)computeResult.config()).scaler());
        return procResultBuilder;
    }

    static <CONFIG extends PageRankConfig> NodePropertyValues nodeProperties(ComputationResult<PageRankAlgorithm, PageRankResult, CONFIG> computeResult) {
        return ((PageRankResult)computeResult.result()).scores().asNodeProperties();
    }

    static abstract class PageRankResultBuilder<PROC_RESULT>
    extends AbstractCentralityResultBuilder<PROC_RESULT> {
        protected long ranIterations;
        protected boolean didConverge;

        PageRankResultBuilder(ProcedureCallContext callContext, int concurrency) {
            super(callContext, concurrency);
        }

        PageRankResultBuilder<PROC_RESULT> withRanIterations(long ranIterations) {
            this.ranIterations = ranIterations;
            return this;
        }

        PageRankResultBuilder<PROC_RESULT> withDidConverge(boolean didConverge) {
            this.didConverge = didConverge;
            return this;
        }
    }
}

