/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.common.CentralityStreamResult;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.pagerank.PageRankAlgorithm;
import org.neo4j.gds.pagerank.PageRankAlgorithmFactory;
import org.neo4j.gds.pagerank.PageRankProc;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.pagerank.PageRankStreamConfig;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.pageRank.stream", description="Page Rank is an algorithm that measures the transitive influence or connectivity of nodes.", executionMode=ExecutionMode.STREAM)
public class PageRankStreamProc
extends StreamProc<PageRankAlgorithm, PageRankResult, CentralityStreamResult, PageRankStreamConfig> {
    @Procedure(value="gds.pageRank.stream", mode=Mode.READ)
    @Description(value="Page Rank is an algorithm that measures the transitive influence or connectivity of nodes.")
    public Stream<CentralityStreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.stream(computationResult);
    }

    @Procedure(value="gds.pageRank.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected CentralityStreamResult streamResult(long originalNodeId, long internalNodeId, NodePropertyValues nodePropertyValues) {
        return new CentralityStreamResult(originalNodeId, nodePropertyValues.doubleValue(internalNodeId));
    }

    protected PageRankStreamConfig newConfig(String username, CypherMapWrapper config) {
        return PageRankStreamConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<PageRankAlgorithm, PageRankStreamConfig> algorithmFactory() {
        return new PageRankAlgorithmFactory();
    }

    protected NodePropertyValues nodeProperties(ComputationResult<PageRankAlgorithm, PageRankResult, PageRankStreamConfig> computationResult) {
        return PageRankProc.nodeProperties(computationResult);
    }
}

