/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Collection;
import java.util.function.Supplier;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.ImmutableGraphLoaderContext;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.Username;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.loading.GraphStoreWithConfig;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.GraphStoreFromCatalogLoader;
import org.neo4j.gds.executor.ImmutableExecutionContext;
import org.neo4j.gds.executor.MemoryUsageValidator;
import org.neo4j.gds.transaction.SecurityContextWrapper;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;

public abstract class BaseProc {
    protected static final String ESTIMATE_DESCRIPTION = "Returns an estimation of the memory consumption for that procedure.";
    @Context
    public GraphDatabaseAPI api;
    @Context
    public Log log;
    @Context
    public Transaction procedureTransaction;
    @Context
    public KernelTransaction transaction;
    @Context
    public ProcedureCallContext callContext;
    @Context
    public TaskRegistryFactory taskRegistryFactory;
    @Context
    public UserLogRegistryFactory userLogRegistryFactory;
    @Context
    public Username username = Username.EMPTY_USERNAME;
    @Context
    public ModelCatalog internalModelCatalog;

    protected String username() {
        return this.username.username();
    }

    protected NamedDatabaseId databaseId() {
        return this.api.databaseId();
    }

    protected GraphStoreWithConfig graphStoreFromCatalog(String graphName, BaseConfig config) {
        return GraphStoreFromCatalogLoader.graphStoreFromCatalog((String)graphName, (BaseConfig)config, (String)this.username(), (NamedDatabaseId)this.databaseId(), (boolean)this.isGdsAdmin());
    }

    public boolean isGdsAdmin() {
        if (this.transaction == null) {
            return false;
        }
        return ((SecurityContextWrapper)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)this.api, SecurityContextWrapper.class)).isAdmin(this.transaction.securityContext());
    }

    protected final void runWithExceptionLogging(String message, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            this.log.warn(message, (Throwable)e);
            throw e;
        }
    }

    protected final <R> R runWithExceptionLogging(String message, Supplier<R> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            this.log.warn(message, (Throwable)e);
            throw e;
        }
    }

    protected final void validateConfig(CypherMapWrapper cypherConfig, BaseConfig config) {
        this.validateConfig(cypherConfig, config.configKeys());
    }

    protected final void validateConfig(CypherMapWrapper cypherConfig, Collection<String> allowedKeys) {
        cypherConfig.requireOnlyKeysFrom(allowedKeys);
    }

    protected final void validateGraphName(String username, String graphName) {
        CypherMapWrapper.failOnBlank((String)"graphName", (String)graphName);
        if (GraphStoreCatalog.exists((String)username, (NamedDatabaseId)this.databaseId(), (String)graphName)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"A graph with name '%s' already exists.", (Object[])new Object[]{graphName}));
        }
    }

    protected GraphLoaderContext graphLoaderContext() {
        return ImmutableGraphLoaderContext.builder().transactionContext(TransactionContext.of((GraphDatabaseAPI)this.api, (Transaction)this.procedureTransaction)).api(this.api).log(this.log).taskRegistryFactory(this.taskRegistryFactory).userLogRegistryFactory(this.userLogRegistryFactory).terminationFlag(TerminationFlag.wrap((KernelTransaction)this.transaction)).build();
    }

    public MemoryUsageValidator memoryUsageValidator() {
        return new MemoryUsageValidator(this.log, this.api);
    }

    public ExecutionContext executionContext() {
        return ImmutableExecutionContext.builder().api(this.api).modelCatalog(this.internalModelCatalog).log(this.log).procedureTransaction(this.procedureTransaction).transaction(this.transaction).callContext(this.callContext).userLogRegistryFactory(this.userLogRegistryFactory).taskRegistryFactory(this.taskRegistryFactory).username(this.username()).build();
    }

    public ModelCatalog modelCatalog() {
        if (this.internalModelCatalog == null) {
            throw new IllegalStateException("ModelCatalog could not be retrieved. Please report the error.");
        }
        return this.internalModelCatalog;
    }

    public void setModelCatalog(ModelCatalog modelCatalog) {
        this.internalModelCatalog = modelCatalog;
    }
}

