/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.stream.Stream;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.LoggingUtil;
import org.neo4j.gds.ResultBuilderFunction;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.MutateConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.result.AbstractResultBuilder;

public abstract class MutateComputationResultConsumer<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends MutateConfig, RESULT>
implements ComputationResultConsumer<ALGO, ALGO_RESULT, CONFIG, Stream<RESULT>> {
    private final ResultBuilderFunction<ALGO, ALGO_RESULT, CONFIG, RESULT> resultBuilderFunction;

    protected MutateComputationResultConsumer(ResultBuilderFunction<ALGO, ALGO_RESULT, CONFIG, RESULT> resultBuilderFunction) {
        this.resultBuilderFunction = resultBuilderFunction;
    }

    public Stream<RESULT> consume(ComputationResult<ALGO, ALGO_RESULT, CONFIG> computationResult, ExecutionContext executionContext) {
        return LoggingUtil.runWithExceptionLogging("Graph mutation failed", executionContext.log(), () -> {
            MutateConfig config = (MutateConfig)computationResult.config();
            AbstractResultBuilder builder = this.resultBuilderFunction.apply(computationResult, executionContext).withPreProcessingMillis(computationResult.preProcessingMillis()).withComputeMillis(computationResult.computeMillis()).withNodeCount(computationResult.graph().nodeCount()).withConfig((AlgoBaseConfig)config);
            if (!computationResult.isGraphEmpty()) {
                this.updateGraphStore(builder, computationResult, executionContext);
                computationResult.graph().releaseProperties();
            }
            return Stream.of(builder.build());
        });
    }

    protected abstract void updateGraphStore(AbstractResultBuilder<?> var1, ComputationResult<ALGO, ALGO_RESULT, CONFIG> var2, ExecutionContext var3);
}

