/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.stream.Stream;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.LoggingUtil;
import org.neo4j.gds.NodePropertyListFunction;
import org.neo4j.gds.ResultBuilderFunction;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.core.write.NodePropertyExporterBuilder;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.result.AbstractResultBuilder;

public class WriteNodePropertiesComputationResultConsumer<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends WritePropertyConfig & AlgoBaseConfig, RESULT>
implements ComputationResultConsumer<ALGO, ALGO_RESULT, CONFIG, Stream<RESULT>> {
    private final ResultBuilderFunction<ALGO, ALGO_RESULT, CONFIG, RESULT> resultBuilderFunction;
    private final WriteNodePropertyListFunction<ALGO, ALGO_RESULT, CONFIG> nodePropertyListFunction;
    private final NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder;
    private final String procedureName;

    WriteNodePropertiesComputationResultConsumer(ResultBuilderFunction<ALGO, ALGO_RESULT, CONFIG, RESULT> resultBuilderFunction, WriteNodePropertyListFunction<ALGO, ALGO_RESULT, CONFIG> nodePropertyListFunction, NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder, String procedureName) {
        this.resultBuilderFunction = resultBuilderFunction;
        this.nodePropertyListFunction = nodePropertyListFunction;
        this.nodePropertyExporterBuilder = nodePropertyExporterBuilder;
        this.procedureName = procedureName;
    }

    public Stream<RESULT> consume(ComputationResult<ALGO, ALGO_RESULT, CONFIG> computationResult, ExecutionContext executionContext) {
        return LoggingUtil.runWithExceptionLogging("Graph write failed", executionContext.log(), () -> {
            WritePropertyConfig config = (WritePropertyConfig)computationResult.config();
            AbstractResultBuilder builder = this.resultBuilderFunction.apply(computationResult, executionContext).withPreProcessingMillis(computationResult.preProcessingMillis()).withComputeMillis(computationResult.computeMillis()).withNodeCount(computationResult.graph().nodeCount()).withConfig((AlgoBaseConfig)config);
            if (!computationResult.isGraphEmpty()) {
                this.writeToNeo(builder, computationResult, executionContext);
                computationResult.graph().releaseProperties();
            }
            return Stream.of(builder.build());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToNeo(AbstractResultBuilder<?> resultBuilder, ComputationResult<ALGO, ALGO_RESULT, CONFIG> computationResult, ExecutionContext executionContext) {
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withWriteMillis(arg_0));){
            Graph graph = computationResult.graph();
            ProgressTracker progressTracker = this.createProgressTracker(graph.nodeCount(), ((WritePropertyConfig)computationResult.config()).writeConcurrency(), executionContext);
            NodePropertyExporter exporter = this.createNodePropertyExporter(graph, progressTracker, computationResult);
            try {
                exporter.write(this.nodePropertyListFunction.apply(computationResult));
            }
            finally {
                progressTracker.release();
            }
            resultBuilder.withNodeCount(computationResult.graph().nodeCount());
            resultBuilder.withNodePropertiesWritten(exporter.propertiesWritten());
        }
    }

    ProgressTracker createProgressTracker(long taskVolume, int writeConcurrency, ExecutionContext executionContext) {
        return new TaskProgressTracker(NodePropertyExporter.baseTask((String)this.procedureName, (long)taskVolume), executionContext.log(), writeConcurrency, executionContext.taskRegistryFactory());
    }

    NodePropertyExporter createNodePropertyExporter(Graph graph, ProgressTracker progressTracker, ComputationResult<ALGO, ALGO_RESULT, CONFIG> computationResult) {
        return this.nodePropertyExporterBuilder.withIdMap((IdMap)graph).withTerminationFlag(computationResult.algorithm().terminationFlag).withProgressTracker(progressTracker).parallel(Pools.DEFAULT, ((WritePropertyConfig)computationResult.config()).writeConcurrency()).build();
    }

    static interface WriteNodePropertyListFunction<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends WritePropertyConfig & AlgoBaseConfig>
    extends NodePropertyListFunction<ALGO, ALGO_RESULT, CONFIG> {
    }
}

