/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.functions;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class AsNodeFunc {
    @Context
    public KernelTransaction tx;

    @UserFunction(value="gds.util.asNode")
    @Description(value="RETURN gds.util.asNode(nodeId) - Return the node objects for the given node id or null if none exists.")
    @Nullable
    public Node asNode(@Name(value="nodeId") Number nodeId) {
        return GraphDatabaseApiProxy.getNodeById((KernelTransaction)this.tx, (long)nodeId.longValue());
    }

    @UserFunction(value="gds.util.asNodes")
    @Description(value="RETURN gds.util.asNodes(nodeIds) - Return the node objects for the given node ids or an empty list if none exists.")
    public List<Node> asNodes(@Name(value="nodeIds") List<Number> nodeIds) {
        return nodeIds.stream().map(nodeId -> GraphDatabaseApiProxy.getNodeById((KernelTransaction)this.tx, (long)nodeId.longValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

