/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.nodeproperties;

import org.neo4j.gds.api.nodeproperties.LongNodeProperties;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeLongLongMap;
import org.neo4j.gds.mem.BitUtil;

public class ConsecutiveLongNodeProperties
implements LongNodeProperties {
    private static final long MAPPING_SIZE_QUOTIENT = 10L;
    private final HugeLongArray communities;

    public ConsecutiveLongNodeProperties(LongNodeProperties longNodeProperties, long nodeCount) {
        long nextConsecutiveId = -1L;
        HugeLongLongMap setIdToConsecutiveId = new HugeLongLongMap(BitUtil.ceilDiv((long)nodeCount, (long)10L));
        this.communities = HugeLongArray.newArray((long)nodeCount);
        int nodeId = 0;
        while ((long)nodeId < nodeCount) {
            long setId = longNodeProperties.longValue((long)nodeId);
            long communityId = setIdToConsecutiveId.getOrDefault(setId, -1L);
            if (communityId == -1L) {
                setIdToConsecutiveId.addTo(setId, ++nextConsecutiveId);
                communityId = nextConsecutiveId;
            }
            this.communities.set((long)nodeId, communityId);
            ++nodeId;
        }
    }

    public long longValue(long nodeId) {
        return this.communities.get(nodeId);
    }

    public long size() {
        return this.communities.size();
    }
}

