/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.MutateComputationResultConsumer;
import org.neo4j.gds.NodePropertyListFunction;
import org.neo4j.gds.ResultBuilderFunction;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.config.MutatePropertyConfig;
import org.neo4j.gds.core.huge.FilteredNodePropertyValues;
import org.neo4j.gds.core.write.ImmutableNodeProperty;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.result.AbstractResultBuilder;

public class MutatePropertyComputationResultConsumer<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends MutatePropertyConfig, RESULT>
extends MutateComputationResultConsumer<ALGO, ALGO_RESULT, CONFIG, RESULT> {
    private final MutateNodePropertyListFunction<ALGO, ALGO_RESULT, CONFIG> nodePropertyListFunction;

    public MutatePropertyComputationResultConsumer(MutateNodePropertyListFunction<ALGO, ALGO_RESULT, CONFIG> nodePropertyListFunction, ResultBuilderFunction<ALGO, ALGO_RESULT, CONFIG, RESULT> resultBuilderFunction) {
        super(resultBuilderFunction);
        this.nodePropertyListFunction = nodePropertyListFunction;
    }

    @Override
    protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, ComputationResult<ALGO, ALGO_RESULT, CONFIG> computationResult, ExecutionContext executionContext) {
        Graph graph = computationResult.graph();
        MutatePropertyConfig mutatePropertyConfig = (MutatePropertyConfig)computationResult.config();
        List<NodeProperty> nodeProperties = this.nodePropertyListFunction.apply(computationResult);
        List<NodeProperty> maybeTranslatedProperties = graph.asNodeFilteredGraph().map(filteredGraph -> nodeProperties.stream().map(nodeProperty -> ImmutableNodeProperty.of((String)nodeProperty.propertyKey(), (NodePropertyValues)new FilteredNodePropertyValues.OriginalToFilteredNodePropertyValues(nodeProperty.properties(), filteredGraph))).collect(Collectors.toList())).orElse(nodeProperties);
        executionContext.log().debug("Updating in-memory graph store");
        GraphStore graphStore = computationResult.graphStore();
        Collection labelsToUpdate = mutatePropertyConfig.nodeLabelIdentifiers(graphStore);
        maybeTranslatedProperties.forEach(nodeProperty -> graphStore.addNodeProperty(new HashSet(labelsToUpdate), nodeProperty.propertyKey(), nodeProperty.properties()));
        resultBuilder.withNodePropertiesWritten((long)maybeTranslatedProperties.size() * computationResult.graph().nodeCount());
    }

    public static interface MutateNodePropertyListFunction<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends MutatePropertyConfig>
    extends NodePropertyListFunction<ALGO, ALGO_RESULT, CONFIG> {
    }
}

