/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.function.Consumer;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.core.Username;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.logging.Log;

public final class ProcedureRunner {
    private ProcedureRunner() {
    }

    public static <P extends BaseProc> P instantiateProcedure(GraphDatabaseService databaseService, Class<P> procClass, ProcedureCallContext procedureCallContext, Log log, TaskRegistryFactory taskRegistryFactory, UserLogRegistryFactory userLogRegistryFactory, Transaction tx, Username username) {
        BaseProc proc;
        try {
            proc = (BaseProc)procClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not instantiate Procedure Class " + procClass.getSimpleName(), e);
        }
        proc.procedureTransaction = tx;
        proc.transaction = GraphDatabaseApiProxy.kernelTransaction((Transaction)tx);
        proc.databaseService = databaseService;
        proc.callContext = procedureCallContext;
        proc.log = log;
        proc.taskRegistryFactory = taskRegistryFactory;
        proc.userLogRegistryFactory = userLogRegistryFactory;
        proc.username = username;
        proc.internalModelCatalog = (ModelCatalog)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)proc.databaseService, ModelCatalog.class);
        return (P)proc;
    }

    public static <P extends BaseProc> P applyOnProcedure(GraphDatabaseService databaseService, Class<P> procClass, ProcedureCallContext procedureCallContext, Log log, TaskRegistryFactory taskRegistryFactory, Transaction tx, Username username, Consumer<P> func) {
        P proc = ProcedureRunner.instantiateProcedure(databaseService, procClass, procedureCallContext, log, taskRegistryFactory, (UserLogRegistryFactory)EmptyUserLogRegistryFactory.INSTANCE, tx, username);
        func.accept(proc);
        return proc;
    }
}

