/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;

public abstract class StreamProc<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT, PROC_RESULT, CONFIG extends AlgoBaseConfig>
extends AlgoBaseProc<ALGO, ALGO_RESULT, CONFIG, PROC_RESULT> {
    protected abstract PROC_RESULT streamResult(long var1, long var3, NodePropertyValues var5);

    public ComputationResultConsumer<ALGO, ALGO_RESULT, CONFIG, Stream<PROC_RESULT>> computationResultConsumer() {
        return (computationResult, executionContext) -> this.runWithExceptionLogging("Result streaming failed", () -> {
            if (computationResult.isGraphEmpty()) {
                return Stream.empty();
            }
            Graph graph = computationResult.graph();
            NodePropertyValues nodePropertyValues = this.nodeProperties(computationResult);
            return LongStream.range(0L, graph.nodeCount()).mapToObj(nodeId -> this.streamResult(graph.toOriginalNodeId(nodeId), nodeId, nodePropertyValues));
        });
    }

    protected Stream<PROC_RESULT> stream(ComputationResult<ALGO, ALGO_RESULT, CONFIG> computationResult) {
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }
}

