/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.List;
import java.util.stream.Stream;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.NodePropertiesWriter;
import org.neo4j.gds.WriteNodePropertiesComputationResultConsumer;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.write.ImmutableNodeProperty;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.core.write.NodePropertyExporterBuilder;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.result.AbstractResultBuilder;

public abstract class WriteProc<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT, PROC_RESULT, CONFIG extends WritePropertyConfig & AlgoBaseConfig>
extends NodePropertiesWriter<ALGO, ALGO_RESULT, CONFIG, PROC_RESULT> {
    protected abstract AbstractResultBuilder<PROC_RESULT> resultBuilder(ComputationResult<ALGO, ALGO_RESULT, CONFIG> var1, ExecutionContext var2);

    @Override
    protected NodePropertyValues nodeProperties(ComputationResult<ALGO, ALGO_RESULT, CONFIG> computationResult) {
        throw new UnsupportedOperationException("Write procedures must implement either `nodeProperties` or `nodePropertyList`.");
    }

    protected List<NodeProperty> nodePropertyList(ComputationResult<ALGO, ALGO_RESULT, CONFIG> computationResult) {
        return List.of(ImmutableNodeProperty.of((String)((WritePropertyConfig)computationResult.config()).writeProperty(), (NodePropertyValues)this.nodeProperties(computationResult)));
    }

    protected Stream<PROC_RESULT> write(ComputationResult<ALGO, ALGO_RESULT, CONFIG> computeResult) {
        return this.computationResultConsumer().consume((ComputationResult)computeResult, this.executionContext());
    }

    public WriteNodePropertiesComputationResultConsumer<ALGO, ALGO_RESULT, CONFIG, PROC_RESULT> computationResultConsumer() {
        return new WriteNodePropertiesComputationResultConsumer(this::resultBuilder, computationResult -> this.nodePropertyList(computationResult), (NodePropertyExporterBuilder<? extends NodePropertyExporter>)this.nodePropertyExporterBuilder, this.name());
    }
}

