/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.functions;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.Username;
import org.neo4j.gds.core.loading.CatalogRequest;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.FloatArray;

public class NodePropertyFunc {
    @Context
    public GraphDatabaseService databaseService;
    @Context
    public Username username = Username.EMPTY_USERNAME;

    @UserFunction(value="gds.util.nodeProperty")
    @Description(value="Returns a node property value from a named in-memory graph.")
    public Object nodeProperty(@Name(value="graphName") String graphName, @Name(value="nodeId") Number nodeId, @Name(value="propertyKey") String propertyKey, @Name(value="nodeLabel", defaultValue="*") String nodeLabel) {
        long internalId;
        NodeLabel nodeLabelType;
        Objects.requireNonNull(graphName);
        Objects.requireNonNull(nodeId);
        Objects.requireNonNull(propertyKey);
        Objects.requireNonNull(nodeLabel);
        GraphStore graphStore = GraphStoreCatalog.get((CatalogRequest)CatalogRequest.of((String)this.username.username(), (DatabaseId)DatabaseId.of((GraphDatabaseService)this.databaseService)), (String)graphName).graphStore();
        boolean projectAll = nodeLabel.equals("*");
        NodeLabel nodeLabel2 = nodeLabelType = projectAll ? NodeLabel.ALL_NODES : NodeLabel.of((String)nodeLabel);
        if (projectAll) {
            long labelsWithProperty = graphStore.nodeLabels().stream().filter(label -> graphStore.hasNodeProperty(Collections.singletonList(label), propertyKey)).count();
            if (labelsWithProperty == 0L) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No node projection with property '%s' exists.", (Object[])new Object[]{propertyKey}));
            }
        } else if (!graphStore.hasNodeProperty(Collections.singletonList(nodeLabelType), propertyKey)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Node projection '%s' does not have property key '%s'. Available keys: %s.", (Object[])new Object[]{nodeLabel, propertyKey, StringJoining.join((Collection)graphStore.nodePropertyKeys(NodeLabel.of((String)nodeLabel)))}));
        }
        if ((internalId = graphStore.nodes().safeToMappedNodeId(nodeId.longValue())) == -1L) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Node id %d does not exist.", (Object[])new Object[]{nodeId.longValue()}));
        }
        if (!projectAll && !graphStore.nodes().hasLabel(internalId, nodeLabelType)) {
            return null;
        }
        NodePropertyValues propertyValues = (NodePropertyValues)graphStore.nodeProperty(propertyKey).values();
        switch (propertyValues.valueType()) {
            case LONG: {
                long longValue = propertyValues.longValue(internalId);
                return longValue == Long.MIN_VALUE ? Double.NaN : (double)longValue;
            }
            case DOUBLE: {
                double propertyValue = propertyValues.doubleValue(internalId);
                return Double.isNaN(propertyValue) ? null : Double.valueOf(propertyValue);
            }
            case DOUBLE_ARRAY: {
                double[] doubleArray = ((DoubleArray)propertyValues.value(internalId)).asObjectCopy();
                return doubleArray == null ? new double[]{} : doubleArray;
            }
            case FLOAT_ARRAY: {
                float[] floatArray = ((FloatArray)propertyValues.value(internalId)).asObjectCopy();
                return floatArray == null ? new float[]{} : floatArray;
            }
            case LONG_ARRAY: {
                long[] longArray = propertyValues.longArrayValue(internalId);
                return longArray == null ? new long[]{} : longArray;
            }
        }
        throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Cannot retrieve value from a property with type %s", (Object[])new Object[]{propertyValues.valueType()}));
    }
}

