/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.nodeproperties;

import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeLongLongMap;
import org.neo4j.gds.mem.BitUtil;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class ConsecutiveLongNodePropertyValues
implements LongNodePropertyValues {
    private static final long MAPPING_SIZE_QUOTIENT = 10L;
    private final HugeLongArray communities;

    public ConsecutiveLongNodePropertyValues(LongNodePropertyValues inputProperties) {
        long nextConsecutiveId = -1L;
        long nextSkippableId = -2L;
        long maxIdx = inputProperties.nodeCount();
        HugeLongLongMap setIdToConsecutiveId = new HugeLongLongMap(BitUtil.ceilDiv((long)maxIdx, (long)10L));
        this.communities = HugeLongArray.newArray((long)maxIdx);
        int nodeId = 0;
        while ((long)nodeId < maxIdx) {
            long setId = inputProperties.longValue((long)nodeId);
            long communityId = setIdToConsecutiveId.getOrDefault(setId, -1L);
            if (communityId == -1L) {
                if (inputProperties.value((long)nodeId) != null) {
                    setIdToConsecutiveId.addTo(setId, ++nextConsecutiveId);
                    communityId = nextConsecutiveId;
                } else {
                    setIdToConsecutiveId.addTo(setId, --nextSkippableId);
                    communityId = nextSkippableId;
                }
            }
            this.communities.set((long)nodeId, communityId);
            ++nodeId;
        }
    }

    public long longValue(long nodeId) {
        return this.communities.get(nodeId);
    }

    public Value value(long nodeId) {
        if (this.communities.get(nodeId) < 0L) {
            return null;
        }
        return Values.longValue((long)this.communities.get(nodeId));
    }

    public long nodeCount() {
        return this.communities.size();
    }
}

