/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.preconditions;

import org.neo4j.configuration.Config;
import org.neo4j.gds.compat.DatabaseMode;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.compat.SettingProxy;
import org.neo4j.graphdb.GraphDatabaseService;

public final class ClusterRestrictions {
    private ClusterRestrictions() {
    }

    public static void disallowRunningOnCluster(GraphDatabaseService databaseService, String detail) throws IllegalStateException {
        Config config = (Config)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)databaseService, Config.class);
        DatabaseMode neo4jMode = SettingProxy.databaseMode((Config)config, (GraphDatabaseService)databaseService);
        if (neo4jMode != DatabaseMode.SINGLE) {
            throw new IllegalStateException("The requested operation (" + detail + ") is not available while running Neo4j Graph Data Science library on a Neo4j Cluster.");
        }
    }
}

