/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.fastrp;

import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.FloatArrayNodeProperties;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.gds.embeddings.fastrp.FastRPBaseConfig;
import org.neo4j.gds.executor.ComputationResult;

final class FastRPCompanion {
    static final String DESCRIPTION = "Random Projection produces node embeddings via the fastrp algorithm";

    private FastRPCompanion() {
    }

    static <CONFIG extends FastRPBaseConfig> NodeProperties getNodeProperties(ComputationResult<FastRP, FastRP.FastRPResult, CONFIG> computationResult) {
        final long nodeCount = computationResult.graph().nodeCount();
        final HugeObjectArray embeddings = ((FastRP.FastRPResult)computationResult.result()).embeddings();
        return new FloatArrayNodeProperties(){

            public float[] floatArrayValue(long nodeId) {
                return (float[])embeddings.get(nodeId);
            }

            public long size() {
                return nodeCount;
            }
        };
    }
}

