/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.fastrp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.gds.embeddings.fastrp.FastRPCompanion;
import org.neo4j.gds.embeddings.fastrp.FastRPFactory;
import org.neo4j.gds.embeddings.fastrp.FastRPStreamConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.fastRP.stream", description="Random Projection produces node embeddings via the fastrp algorithm", executionMode=ExecutionMode.STREAM)
public class FastRPStreamProc
extends StreamProc<FastRP, FastRP.FastRPResult, StreamResult, FastRPStreamConfig> {
    @Procedure(value="gds.fastRP.stream", mode=Mode.READ)
    @Description(value="Random Projection produces node embeddings via the fastrp algorithm")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.stream(computationResult);
    }

    @Procedure(value="gds.fastRP.stream.estimate", mode=Mode.READ)
    @Description(value="Random Projection produces node embeddings via the fastrp algorithm")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected NodeProperties nodeProperties(ComputationResult<FastRP, FastRP.FastRPResult, FastRPStreamConfig> computationResult) {
        return FastRPCompanion.getNodeProperties(computationResult);
    }

    protected StreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        return new StreamResult(originalNodeId, nodeProperties.floatArrayValue(internalNodeId));
    }

    protected FastRPStreamConfig newConfig(String username, CypherMapWrapper config) {
        return FastRPStreamConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<FastRP, FastRPStreamConfig> algorithmFactory() {
        return new FastRPFactory();
    }

    public static final class StreamResult {
        public final long nodeId;
        public final List<Double> embedding;

        StreamResult(long nodeId, float[] embedding) {
            this.nodeId = nodeId;
            this.embedding = new ArrayList<Double>(embedding.length);
            for (float f : embedding) {
                this.embedding.add(Double.valueOf(f));
            }
        }
    }
}

