/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.embeddings.graphsage.GraphSageCompanion;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSage;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageAlgorithmFactory;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageStreamConfig;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.graphSage.stream", description="The GraphSage algorithm inductively computes embeddings for nodes based on a their features and neighborhoods.", executionMode=ExecutionMode.STREAM)
public class GraphSageStreamProc
extends StreamProc<GraphSage, GraphSage.GraphSageResult, GraphSageStreamResult, GraphSageStreamConfig> {
    @Description(value="The GraphSage algorithm inductively computes embeddings for nodes based on a their features and neighborhoods.")
    @Procedure(name="gds.beta.graphSage.stream", mode=Mode.READ)
    public Stream<GraphSageStreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        GraphSageCompanion.injectRelationshipWeightPropertyFromModel(GraphSageCompanion.getActualConfig(graphName, configuration), this.modelCatalog(), this.username.username());
        return this.stream((ComputationResult<GraphSage, GraphSage.GraphSageResult, GraphSageStreamConfig>)this.compute(graphName, configuration));
    }

    @Procedure(value="gds.beta.graphSage.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        GraphSageCompanion.injectRelationshipWeightPropertyFromModel(GraphSageCompanion.getActualConfig(graphNameOrConfiguration, algoConfiguration), this.modelCatalog(), this.username.username());
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected Stream<GraphSageStreamResult> stream(ComputationResult<GraphSage, GraphSage.GraphSageResult, GraphSageStreamConfig> computationResult) {
        return (Stream)this.runWithExceptionLogging("GraphSage streaming failed", () -> {
            Graph graph = computationResult.graph();
            GraphSage.GraphSageResult result = (GraphSage.GraphSageResult)computationResult.result();
            if (result == null) {
                return Stream.empty();
            }
            return LongStream.range(0L, graph.nodeCount()).mapToObj(i -> new GraphSageStreamResult(graph.toOriginalNodeId(i), (double[])result.embeddings().get(i)));
        });
    }

    public ValidationConfiguration<GraphSageStreamConfig> validationConfig() {
        return GraphSageCompanion.getValidationConfig(this.modelCatalog(), this.username());
    }

    public AlgorithmSpec<GraphSage, GraphSage.GraphSageResult, GraphSageStreamConfig, Stream<GraphSageStreamResult>, AlgorithmFactory<?, GraphSage, GraphSageStreamConfig>> withModelCatalog(ModelCatalog modelCatalog) {
        this.setModelCatalog(modelCatalog);
        return this;
    }

    protected GraphSageStreamConfig newConfig(String username, CypherMapWrapper config) {
        return GraphSageStreamConfig.of((String)username, (CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<GraphSage, GraphSageStreamConfig> algorithmFactory() {
        return new GraphSageAlgorithmFactory(this.modelCatalog());
    }

    protected GraphSageStreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        throw new UnsupportedOperationException("GraphSage handles result building individually.");
    }

    public static class GraphSageStreamResult {
        public long nodeId;
        public List<Double> embedding;

        GraphSageStreamResult(long nodeId, double[] embeddings) {
            this.nodeId = nodeId;
            this.embedding = Arrays.stream(embeddings).boxed().collect(Collectors.toList());
        }
    }
}

