/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageTrainConfig;
import org.neo4j.gds.executor.validation.AfterLoadValidation;
import org.neo4j.gds.utils.StringFormatting;

public class GraphSageTrainingConfigValidation
implements AfterLoadValidation<GraphSageTrainConfig> {
    public void validateConfigsAfterLoad(GraphStore graphStore, GraphProjectConfig graphProjectConfig, GraphSageTrainConfig config) {
        Collection nodeLabels = config.nodeLabelIdentifiers(graphStore);
        List nodePropertyNames = config.featureProperties();
        if (config.isMultiLabel()) {
            Set allProperties = graphStore.schema().nodeSchema().allProperties();
            Set missingProperties = nodePropertyNames.stream().filter(key -> !allProperties.contains(key)).collect(Collectors.toSet());
            if (!missingProperties.isEmpty()) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Each property set in `featureProperties` must exist for at least one label. Missing properties: %s", (Object[])new Object[]{missingProperties}));
            }
        } else {
            List missingProperties = nodePropertyNames.stream().filter(weightProperty -> !graphStore.hasNodeProperty(nodeLabels, weightProperty)).collect(Collectors.toList());
            if (!missingProperties.isEmpty()) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The following node properties are not present for each label in the graph: %s. Properties that exist for each label are %s", (Object[])new Object[]{missingProperties, graphStore.nodePropertyKeys(nodeLabels)}));
            }
        }
    }
}

