/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.fastrp;

import org.neo4j.gds.api.properties.nodes.FloatArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.gds.embeddings.fastrp.FastRPBaseConfig;
import org.neo4j.gds.executor.ComputationResult;

final class FastRPCompanion {
    static final String DESCRIPTION = "Random Projection produces node embeddings via the fastrp algorithm";

    private FastRPCompanion() {
    }

    static <CONFIG extends FastRPBaseConfig> NodePropertyValues getNodeProperties(ComputationResult<FastRP, FastRP.FastRPResult, CONFIG> computationResult) {
        final long nodeCount = computationResult.graph().nodeCount();
        final HugeObjectArray embeddings = ((FastRP.FastRPResult)computationResult.result()).embeddings();
        return new FloatArrayNodePropertyValues(){

            public float[] floatArrayValue(long nodeId) {
                return (float[])embeddings.get(nodeId);
            }

            public long nodeCount() {
                return nodeCount;
            }
        };
    }
}

