/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.fastrp;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.gds.embeddings.fastrp.FastRPCompanion;
import org.neo4j.gds.embeddings.fastrp.FastRPFactory;
import org.neo4j.gds.embeddings.fastrp.FastRPMutateConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.fastRP.mutate", description="Random Projection produces node embeddings via the fastrp algorithm", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class FastRPMutateProc
extends MutatePropertyProc<FastRP, FastRP.FastRPResult, MutateResult, FastRPMutateConfig> {
    @Procedure(value="gds.fastRP.mutate", mode=Mode.READ)
    @Description(value="Random Projection produces node embeddings via the fastrp algorithm")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.mutate(computationResult);
    }

    @Procedure(value="gds.fastRP.mutate.estimate", mode=Mode.READ)
    @Description(value="Random Projection produces node embeddings via the fastrp algorithm")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected NodePropertyValues nodeProperties(ComputationResult<FastRP, FastRP.FastRPResult, FastRPMutateConfig> computationResult) {
        return FastRPCompanion.getNodeProperties(computationResult);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<FastRP, FastRP.FastRPResult, FastRPMutateConfig> computeResult, ExecutionContext executionContext) {
        return new MutateResult.Builder();
    }

    protected FastRPMutateConfig newConfig(String username, CypherMapWrapper config) {
        return FastRPMutateConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<FastRP, FastRPMutateConfig> algorithmFactory() {
        return new FastRPFactory();
    }

    public static final class MutateResult {
        public final long nodePropertiesWritten;
        public final long mutateMillis;
        public final long nodeCount;
        public final long preProcessingMillis;
        public final long computeMillis;
        public final Map<String, Object> configuration;

        MutateResult(long nodeCount, long nodePropertiesWritten, long preProcessingMillis, long computeMillis, long mutateMillis, Map<String, Object> config) {
            this.nodeCount = nodeCount;
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.mutateMillis = mutateMillis;
            this.configuration = config;
        }

        static final class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.nodeCount, this.nodePropertiesWritten, this.preProcessingMillis, this.computeMillis, this.mutateMillis, this.config.toMap());
            }
        }
    }
}

