/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.fastrp;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StatsProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.gds.embeddings.fastrp.FastRPFactory;
import org.neo4j.gds.embeddings.fastrp.FastRPStatsConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.fastRP.stats", description="Random Projection produces node embeddings via the fastrp algorithm", executionMode=ExecutionMode.STATS)
public class FastRPStatsProc
extends StatsProc<FastRP, FastRP.FastRPResult, StatsResult, FastRPStatsConfig> {
    @Procedure(value="gds.fastRP.stats", mode=Mode.READ)
    @Description(value="Random Projection produces node embeddings via the fastrp algorithm")
    public Stream<StatsResult> stats(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.stats(computationResult);
    }

    @Procedure(value="gds.fastRP.stats.estimate", mode=Mode.READ)
    @Description(value="Random Projection produces node embeddings via the fastrp algorithm")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected AbstractResultBuilder<StatsResult> resultBuilder(ComputationResult<FastRP, FastRP.FastRPResult, FastRPStatsConfig> computeResult, ExecutionContext executionContext) {
        return new StatsResult.Builder();
    }

    protected FastRPStatsConfig newConfig(String username, CypherMapWrapper config) {
        return FastRPStatsConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<FastRP, FastRPStatsConfig> algorithmFactory() {
        return new FastRPFactory();
    }

    public static final class StatsResult {
        public final long nodeCount;
        public final long preProcessingMillis;
        public final long computeMillis;
        public final Map<String, Object> configuration;

        StatsResult(long nodeCount, long preProcessingMillis, long computeMillis, Map<String, Object> config) {
            this.nodeCount = nodeCount;
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.configuration = config;
        }

        static final class Builder
        extends AbstractResultBuilder<StatsResult> {
            Builder() {
            }

            public StatsResult build() {
                return new StatsResult(this.nodeCount, this.preProcessingMillis, this.computeMillis, this.config.toMap());
            }
        }
    }
}

