/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.fastrp;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.WriteProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.gds.embeddings.fastrp.FastRPCompanion;
import org.neo4j.gds.embeddings.fastrp.FastRPFactory;
import org.neo4j.gds.embeddings.fastrp.FastRPWriteConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.fastRP.write", description="Random Projection produces node embeddings via the fastrp algorithm", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class FastRPWriteProc
extends WriteProc<FastRP, FastRP.FastRPResult, WriteResult, FastRPWriteConfig> {
    @Procedure(value="gds.fastRP.write", mode=Mode.WRITE)
    @Description(value="Random Projection produces node embeddings via the fastrp algorithm")
    public Stream<WriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.write(computationResult);
    }

    @Procedure(value="gds.fastRP.write.estimate", mode=Mode.READ)
    @Description(value="Random Projection produces node embeddings via the fastrp algorithm")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected FastRPWriteConfig newConfig(String username, CypherMapWrapper config) {
        return FastRPWriteConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<FastRP, FastRPWriteConfig> algorithmFactory() {
        return new FastRPFactory();
    }

    protected NodePropertyValues nodeProperties(ComputationResult<FastRP, FastRP.FastRPResult, FastRPWriteConfig> computationResult) {
        return FastRPCompanion.getNodeProperties(computationResult);
    }

    protected AbstractResultBuilder<WriteResult> resultBuilder(ComputationResult<FastRP, FastRP.FastRPResult, FastRPWriteConfig> computeResult, ExecutionContext executionContext) {
        return new WriteResult.Builder();
    }

    public static final class WriteResult {
        public final long nodeCount;
        public final long nodePropertiesWritten;
        public final long preProcessingMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final Map<String, Object> configuration;

        WriteResult(long nodeCount, long nodePropertiesWritten, long preProcessingMillis, long computeMillis, long writeMillis, Map<String, Object> configuration) {
            this.nodeCount = nodeCount;
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.configuration = configuration;
        }

        static class Builder
        extends AbstractResultBuilder<WriteResult> {
            Builder() {
            }

            public WriteResult build() {
                return new WriteResult(this.nodeCount, this.nodePropertiesWritten, this.preProcessingMillis, this.computeMillis, this.writeMillis, this.config.toMap());
            }
        }
    }
}

