/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.embeddings.graphsage.GraphSageCompanion;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSage;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageAlgorithmFactory;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageMutateConfig;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.graphSage.mutate", description="The GraphSage algorithm inductively computes embeddings for nodes based on a their features and neighborhoods.", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class GraphSageMutateProc
extends MutatePropertyProc<GraphSage, GraphSage.GraphSageResult, MutateResult, GraphSageMutateConfig> {
    @Procedure(value="gds.beta.graphSage.mutate", mode=Mode.READ)
    @Description(value="The GraphSage algorithm inductively computes embeddings for nodes based on a their features and neighborhoods.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.mutate(computationResult);
    }

    @Procedure(value="gds.beta.graphSage.mutate.estimate", mode=Mode.READ)
    @Description(value="The GraphSage algorithm inductively computes embeddings for nodes based on a their features and neighborhoods.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected NodePropertyValues nodeProperties(ComputationResult<GraphSage, GraphSage.GraphSageResult, GraphSageMutateConfig> computationResult) {
        return GraphSageCompanion.getNodeProperties(computationResult);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<GraphSage, GraphSage.GraphSageResult, GraphSageMutateConfig> computeResult, ExecutionContext executionContext) {
        return new MutateResult.Builder();
    }

    public ValidationConfiguration<GraphSageMutateConfig> validationConfig() {
        return GraphSageCompanion.getValidationConfig(this.modelCatalog());
    }

    protected GraphSageMutateConfig newConfig(String username, CypherMapWrapper config) {
        return GraphSageMutateConfig.of((String)username, (CypherMapWrapper)config);
    }

    public GraphStoreAlgorithmFactory<GraphSage, GraphSageMutateConfig> algorithmFactory() {
        return new GraphSageAlgorithmFactory(this.modelCatalog());
    }

    public AlgorithmSpec<GraphSage, GraphSage.GraphSageResult, GraphSageMutateConfig, Stream<MutateResult>, AlgorithmFactory<?, GraphSage, GraphSageMutateConfig>> withModelCatalog(ModelCatalog modelCatalog) {
        this.setModelCatalog(modelCatalog);
        return this;
    }

    public static final class MutateResult {
        public final long nodePropertiesWritten;
        public final long mutateMillis;
        public final long nodeCount;
        public final long preProcessingMillis;
        public final long computeMillis;
        public final Map<String, Object> configuration;

        MutateResult(long nodeCount, long nodePropertiesWritten, long preProcessingMillis, long computeMillis, long mutateMillis, Map<String, Object> config) {
            this.nodeCount = nodeCount;
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.mutateMillis = mutateMillis;
            this.configuration = config;
        }

        static final class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.nodeCount, this.nodePropertiesWritten, this.preProcessingMillis, this.computeMillis, this.mutateMillis, this.config.toMap());
            }
        }
    }
}

