/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.WriteProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.embeddings.graphsage.GraphSageCompanion;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSage;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageAlgorithmFactory;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageWriteConfig;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.graphSage.write", description="The GraphSage algorithm inductively computes embeddings for nodes based on a their features and neighborhoods.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class GraphSageWriteProc
extends WriteProc<GraphSage, GraphSage.GraphSageResult, GraphSageWriteResult, GraphSageWriteConfig> {
    @Procedure(name="gds.beta.graphSage.write", mode=Mode.WRITE)
    @Description(value="The GraphSage algorithm inductively computes embeddings for nodes based on a their features and neighborhoods.")
    public Stream<GraphSageWriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.beta.graphSage.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    public ValidationConfiguration<GraphSageWriteConfig> validationConfig() {
        return GraphSageCompanion.getValidationConfig(this.modelCatalog());
    }

    public AlgorithmSpec<GraphSage, GraphSage.GraphSageResult, GraphSageWriteConfig, Stream<GraphSageWriteResult>, AlgorithmFactory<?, GraphSage, GraphSageWriteConfig>> withModelCatalog(ModelCatalog modelCatalog) {
        this.setModelCatalog(modelCatalog);
        return this;
    }

    protected GraphSageWriteConfig newConfig(String username, CypherMapWrapper config) {
        return GraphSageWriteConfig.of((String)username, (CypherMapWrapper)config);
    }

    public GraphStoreAlgorithmFactory<GraphSage, GraphSageWriteConfig> algorithmFactory() {
        return new GraphSageAlgorithmFactory(this.modelCatalog());
    }

    protected NodePropertyValues nodeProperties(ComputationResult<GraphSage, GraphSage.GraphSageResult, GraphSageWriteConfig> computationResult) {
        return GraphSageCompanion.getNodeProperties(computationResult);
    }

    protected AbstractResultBuilder<GraphSageWriteResult> resultBuilder(ComputationResult<GraphSage, GraphSage.GraphSageResult, GraphSageWriteConfig> computeResult, ExecutionContext executionContext) {
        return new GraphSageWriteResult.Builder();
    }

    public static final class GraphSageWriteResult {
        public final long nodeCount;
        public final long nodePropertiesWritten;
        public final long preProcessingMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final Map<String, Object> configuration;

        GraphSageWriteResult(long nodeCount, long nodePropertiesWritten, long preProcessingMillis, long computeMillis, long writeMillis, Map<String, Object> configuration) {
            this.nodeCount = nodeCount;
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.configuration = configuration;
        }

        static class Builder
        extends AbstractResultBuilder<GraphSageWriteResult> {
            Builder() {
            }

            public GraphSageWriteResult build() {
                return new GraphSageWriteResult(this.nodeCount, this.nodePropertiesWritten, this.preProcessingMillis, this.computeMillis, this.writeMillis, this.config.toMap());
            }
        }
    }
}

