/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.hashgnn;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.embeddings.hashgnn.HashGNN;
import org.neo4j.gds.embeddings.hashgnn.HashGNNFactory;
import org.neo4j.gds.embeddings.hashgnn.HashGNNMutateConfig;
import org.neo4j.gds.embeddings.hashgnn.HashGNNProcCompanion;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.hashgnn.mutate", description="HashGNN creates node embeddings by hashing and message passing.", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class HashGNNMutateProc
extends MutatePropertyProc<HashGNN, HashGNN.HashGNNResult, MutateResult, HashGNNMutateConfig> {
    @Procedure(value="gds.beta.hashgnn.mutate", mode=Mode.READ)
    @Description(value="HashGNN creates node embeddings by hashing and message passing.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.mutate(computationResult);
    }

    @Procedure(value="gds.beta.hashgnn.mutate.estimate", mode=Mode.READ)
    @Description(value="HashGNN creates node embeddings by hashing and message passing.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected NodePropertyValues nodeProperties(ComputationResult<HashGNN, HashGNN.HashGNNResult, HashGNNMutateConfig> computationResult) {
        return HashGNNProcCompanion.getNodeProperties(computationResult);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<HashGNN, HashGNN.HashGNNResult, HashGNNMutateConfig> computeResult, ExecutionContext executionContext) {
        return new MutateResult.Builder();
    }

    protected HashGNNMutateConfig newConfig(String username, CypherMapWrapper config) {
        return HashGNNMutateConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<HashGNN, HashGNNMutateConfig> algorithmFactory() {
        return new HashGNNFactory();
    }

    public static final class MutateResult {
        public final long nodePropertiesWritten;
        public final long mutateMillis;
        public final long nodeCount;
        public final long preProcessingMillis;
        public final long computeMillis;
        public final Map<String, Object> configuration;

        MutateResult(long nodeCount, long nodePropertiesWritten, long preProcessingMillis, long computeMillis, long mutateMillis, Map<String, Object> config) {
            this.nodeCount = nodeCount;
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.mutateMillis = mutateMillis;
            this.configuration = config;
        }

        static final class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.nodeCount, this.nodePropertiesWritten, this.preProcessingMillis, this.computeMillis, this.mutateMillis, this.config.toMap());
            }
        }
    }
}

