/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.hashgnn;

import org.neo4j.gds.api.properties.nodes.DoubleArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.embeddings.hashgnn.HashGNN;
import org.neo4j.gds.embeddings.hashgnn.HashGNNConfig;
import org.neo4j.gds.executor.ComputationResult;

final class HashGNNProcCompanion {
    public static final String DESCRIPTION = "HashGNN creates node embeddings by hashing and message passing.";

    private HashGNNProcCompanion() {
    }

    static <CONFIG extends HashGNNConfig> NodePropertyValues getNodeProperties(ComputationResult<HashGNN, HashGNN.HashGNNResult, CONFIG> computationResult) {
        final long nodeCount = computationResult.graph().nodeCount();
        final HugeObjectArray embeddings = ((HashGNN.HashGNNResult)computationResult.result()).embeddings();
        return new DoubleArrayNodePropertyValues(){

            public double[] doubleArrayValue(long nodeId) {
                return (double[])embeddings.get(nodeId);
            }

            public long nodeCount() {
                return nodeCount;
            }
        };
    }
}

