/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.hashgnn;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.embeddings.hashgnn.HashGNN;
import org.neo4j.gds.embeddings.hashgnn.HashGNNFactory;
import org.neo4j.gds.embeddings.hashgnn.HashGNNProcCompanion;
import org.neo4j.gds.embeddings.hashgnn.HashGNNStreamConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.hashgnn.stream", description="HashGNN creates node embeddings by hashing and message passing.", executionMode=ExecutionMode.STREAM)
public class HashGNNStreamProc
extends StreamProc<HashGNN, HashGNN.HashGNNResult, StreamResult, HashGNNStreamConfig> {
    @Procedure(value="gds.beta.hashgnn.stream", mode=Mode.READ)
    @Description(value="HashGNN creates node embeddings by hashing and message passing.")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.stream((ComputationResult<HashGNN, HashGNN.HashGNNResult, HashGNNStreamConfig>)computationResult);
    }

    @Procedure(value="gds.beta.hashgnn.stream.estimate", mode=Mode.READ)
    @Description(value="HashGNN creates node embeddings by hashing and message passing.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected Stream<StreamResult> stream(ComputationResult<HashGNN, HashGNN.HashGNNResult, HashGNNStreamConfig> computationResult) {
        return (Stream)this.runWithExceptionLogging("HashGNN streaming failed", () -> {
            Graph graph = computationResult.graph();
            HashGNN.HashGNNResult result = (HashGNN.HashGNNResult)computationResult.result();
            if (result == null) {
                return Stream.empty();
            }
            return LongStream.range(0L, graph.nodeCount()).mapToObj(i -> new StreamResult(graph.toOriginalNodeId(i), (double[])result.embeddings().get(i)));
        });
    }

    protected NodePropertyValues nodeProperties(ComputationResult<HashGNN, HashGNN.HashGNNResult, HashGNNStreamConfig> computationResult) {
        return HashGNNProcCompanion.getNodeProperties(computationResult);
    }

    protected StreamResult streamResult(long originalNodeId, long internalNodeId, NodePropertyValues nodePropertyValues) {
        throw new UnsupportedOperationException("HashGNN handles result building individually.");
    }

    protected HashGNNStreamConfig newConfig(String username, CypherMapWrapper config) {
        return HashGNNStreamConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<HashGNN, HashGNNStreamConfig> algorithmFactory() {
        return new HashGNNFactory();
    }

    public static final class StreamResult {
        public final long nodeId;
        public final List<Double> embedding;

        StreamResult(long nodeId, double[] embeddings) {
            this.nodeId = nodeId;
            this.embedding = Arrays.stream(embeddings).boxed().collect(Collectors.toList());
        }
    }
}

