/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.stream.Stream;
import org.neo4j.gds.utils.GdsFeatureToggles;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class FeatureToggleProc {
    @Internal
    @Procedure(value="gds.features.importer.skipOrphanNodes")
    @Description(value="Toggle whether orphan nodes should be skipped during import.")
    public void skipOrphanNodes(@Name(value="skipOrphanNodes") boolean skipOrphanNodes) {
        GdsFeatureToggles.SKIP_ORPHANS.toggle(skipOrphanNodes);
    }

    @Internal
    @Procedure(value="gds.features.importer.skipOrphanNodes.reset")
    @Description(value="Set the behavior of whether to skip orphan nodes to the default. That value is returned.")
    public Stream<FeatureState> resetSkipOrphanNodes() {
        GdsFeatureToggles.SKIP_ORPHANS.reset();
        return Stream.of(new FeatureState(GdsFeatureToggles.SKIP_ORPHANS.isEnabled()));
    }

    @Internal
    @Procedure(value="gds.features.usePropertyValueIndex")
    @Description(value="Toggle whether the property value index should be used during node property loading.")
    public void usePropertyValueIndex(@Name(value="usePropertyValueIndex") boolean usePropertyValueIndex) {
        GdsFeatureToggles.USE_PROPERTY_VALUE_INDEX.toggle(usePropertyValueIndex);
    }

    @Internal
    @Procedure(value="gds.features.usePropertyValueIndex.reset")
    @Description(value="Set the behavior of whether to use the property value index to the default. That value is returned.")
    public Stream<FeatureState> resetUsePropertyValueIndex() {
        GdsFeatureToggles.USE_PROPERTY_VALUE_INDEX.reset();
        return Stream.of(new FeatureState(GdsFeatureToggles.USE_PROPERTY_VALUE_INDEX.isEnabled()));
    }

    @Internal
    @Procedure(value="gds.features.useParallelPropertyValueIndex")
    @Description(value="Toggle whether the property value index should be read in parallel during node property loading. Only works if usePropertyValueIndex is set as well")
    public void useParallelPropertyValueIndex(@Name(value="useParallelPropertyValueIndex") boolean useParallelPropertyValueIndex) {
        GdsFeatureToggles.USE_PARALLEL_PROPERTY_VALUE_INDEX.toggle(useParallelPropertyValueIndex);
    }

    @Internal
    @Procedure(value="gds.features.useParallelPropertyValueIndex.reset")
    @Description(value="Set the behavior of whether to use the property value index to the default. That value is returned.")
    public Stream<FeatureState> resetUseParallelPropertyValueIndex() {
        GdsFeatureToggles.USE_PARALLEL_PROPERTY_VALUE_INDEX.reset();
        return Stream.of(new FeatureState(GdsFeatureToggles.USE_PARALLEL_PROPERTY_VALUE_INDEX.isEnabled()));
    }

    @Internal
    @Procedure(value="gds.features.maxArrayLengthShift")
    @Description(value="Toggle how large arrays are allowed to get before they are being paged; value is a power of two.")
    public void maxArrayLengthShift(@Name(value="maxArrayLengthShift") long maxArrayLengthShift) {
        if (maxArrayLengthShift <= 0L || maxArrayLengthShift >= 32L) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Invalid value for maxArrayLengthShift, must be in (0, %d)", (Object[])new Object[]{32}));
        }
        GdsFeatureToggles.MAX_ARRAY_LENGTH_SHIFT.set((int)maxArrayLengthShift);
    }

    @Internal
    @Procedure(value="gds.features.pagesPerThread")
    @Description(value="Toggle how many pages per thread are being used by the loader.")
    public void pagesPerThread(@Name(value="pagesPerThread") long pagesPerThread) {
        if (pagesPerThread <= 0L || pagesPerThread > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Invalid value for pagesPerThread: %d, must be a non-zero, positive integer", (Object[])new Object[]{pagesPerThread}));
        }
        GdsFeatureToggles.PAGES_PER_THREAD.set((int)pagesPerThread);
    }

    @Internal
    @Procedure(value="gds.features.useUncompressedAdjacencyList")
    @Description(value="Toggle whether the adjacency list should be stored uncompressed during graph creation.")
    public void useUncompressedAdjacencyList(@Name(value="useUncompressedAdjacencyList") boolean useUncompressedAdjacencyList) {
        GdsFeatureToggles.USE_UNCOMPRESSED_ADJACENCY_LIST.toggle(useUncompressedAdjacencyList);
    }

    @Internal
    @Procedure(value="gds.features.useUncompressedAdjacencyList.reset")
    @Description(value="Set the default behaviour of whether to store uncompressed adjacency lists during graph creation. That value is returned.")
    public Stream<FeatureState> resetUseUncompressedAdjacencyList() {
        GdsFeatureToggles.USE_UNCOMPRESSED_ADJACENCY_LIST.reset();
        return Stream.of(new FeatureState(GdsFeatureToggles.USE_UNCOMPRESSED_ADJACENCY_LIST.isEnabled()));
    }

    @Internal
    @Procedure(value="gds.features.useReorderedAdjacencyList")
    @Description(value="Toggle whether the adjacency list should be reordered during graph creation.")
    public void useReorderedAdjacencyList(@Name(value="useReorderedAdjacencyList") boolean useReorderedAdjacencyList) {
        GdsFeatureToggles.USE_REORDERED_ADJACENCY_LIST.toggle(useReorderedAdjacencyList);
    }

    @Internal
    @Procedure(value="gds.features.useReorderedAdjacencyList.reset")
    @Description(value="Set the default behaviour of whether to reorder adjacency lists during graph creation. That value is returned.")
    public Stream<FeatureState> resetUseReorderedAdjacencyList() {
        GdsFeatureToggles.USE_REORDERED_ADJACENCY_LIST.reset();
        return Stream.of(new FeatureState(GdsFeatureToggles.USE_REORDERED_ADJACENCY_LIST.isEnabled()));
    }

    @Internal
    @Procedure(value="gds.features.maxArrayLengthShift.reset")
    @Description(value="Set the value of the max array size before paging to the default. That value is returned.")
    public Stream<FeatureValue> resetMaxArrayLengthShift() {
        GdsFeatureToggles.MAX_ARRAY_LENGTH_SHIFT.set(28);
        return Stream.of(new FeatureValue(28L));
    }

    @Internal
    @Procedure(value="gds.features.pagesPerThread.reset")
    @Description(value="Set the value of pages per thread to the default. That value is returned.")
    public Stream<FeatureValue> resetPagesPerThread() {
        GdsFeatureToggles.PAGES_PER_THREAD.set(4);
        return Stream.of(new FeatureValue(4L));
    }

    public static final class FeatureValue {
        public final long value;

        FeatureValue(long value) {
            this.value = value;
        }
    }

    public static final class FeatureState {
        public final boolean enabled;

        public FeatureState(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

