/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.StructuredOutputHelper;
import org.neo4j.gds.core.utils.ClockService;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.core.utils.progress.TaskStore;
import org.neo4j.gds.core.utils.progress.tasks.DepthAwareTaskVisitor;
import org.neo4j.gds.core.utils.progress.tasks.Progress;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskTraversal;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.storable.LocalTimeValue;

public class ListProgressProc
extends BaseProc {
    static final int PROGRESS_BAR_LENGTH = 10;
    @Context
    public TaskStore taskStore;

    @Procedure(value="gds.beta.listProgress")
    @Description(value="List progress events for currently running tasks.")
    public Stream<ProgressResult> listProgress(@Name(value="jobId", defaultValue="") String jobId) {
        return jobId.isBlank() ? this.jobsSummaryView() : this.jobDetailView(jobId);
    }

    private Stream<ProgressResult> jobsSummaryView() {
        return this.taskStore.query(this.username()).entrySet().stream().map(ProgressResult::fromTaskStoreEntry);
    }

    private Stream<ProgressResult> jobDetailView(String jobIdAsString) {
        JobId jobId = JobId.fromString((String)jobIdAsString);
        Task task = (Task)this.taskStore.query(this.username(), jobId).orElseThrow(() -> new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No task with job id `%s` was found.", (Object[])new Object[]{jobIdAsString})));
        JobProgressVisitor jobProgressVisitor = new JobProgressVisitor(jobId);
        TaskTraversal.visitPreOrderWithDepth((Task)task, (DepthAwareTaskVisitor)jobProgressVisitor);
        return jobProgressVisitor.progressRowsStream();
    }

    public static class JobProgressVisitor
    extends DepthAwareTaskVisitor {
        private final JobId jobId;
        private final List<ProgressResult> progressRows;

        JobProgressVisitor(JobId jobId) {
            this.jobId = jobId;
            this.progressRows = new ArrayList<ProgressResult>();
        }

        Stream<ProgressResult> progressRowsStream() {
            return this.progressRows.stream();
        }

        public void visit(Task task) {
            this.progressRows.add(ProgressResult.fromTaskWithDepth(task, this.jobId, this.depth()));
        }
    }

    public static class ProgressResult {
        public String jobId;
        public String taskName;
        public String progress;
        public String progressBar;
        public String status;
        public LocalTimeValue timeStarted;
        public String elapsedTime;

        static ProgressResult fromTaskStoreEntry(Map.Entry<JobId, Task> taskStoreEntry) {
            JobId jobId = taskStoreEntry.getKey();
            Task task = taskStoreEntry.getValue();
            return new ProgressResult(task, jobId, task.description());
        }

        static ProgressResult fromTaskWithDepth(Task task, JobId jobId, int depth) {
            String treeViewTaskName = StructuredOutputHelper.treeViewDescription(task.description(), depth);
            return new ProgressResult(task, jobId, treeViewTaskName);
        }

        public ProgressResult(Task task, JobId jobId, String taskName) {
            Progress progressContainer = task.getProgress();
            this.jobId = jobId.asString();
            this.taskName = taskName;
            this.progress = StructuredOutputHelper.computeProgress(progressContainer.progress(), progressContainer.volume());
            this.progressBar = StructuredOutputHelper.progressBar(progressContainer.progress(), progressContainer.volume(), 10);
            this.status = task.status().name();
            this.timeStarted = this.localTimeValue(task);
            this.elapsedTime = this.prettyElapsedTime(task);
        }

        private LocalTimeValue localTimeValue(Task task) {
            if (task.hasNotStarted()) {
                return null;
            }
            return LocalTimeValue.localTime((LocalTime)LocalTime.ofInstant(Instant.ofEpochMilli(task.startTime()), ZoneId.systemDefault()));
        }

        private String prettyElapsedTime(Task task) {
            if (task.hasNotStarted()) {
                return "Not yet started";
            }
            long finishTime = task.finishTime();
            long finishTimeOrNow = finishTime != -1L ? finishTime : ClockService.clock().millis();
            long elapsedTime = finishTimeOrNow - task.startTime();
            return DurationFormatUtils.formatDurationWords((long)elapsedTime, (boolean)true, (boolean)true);
        }
    }
}

