/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import org.neo4j.gds.core.utils.progress.tasks.IterativeTask;
import org.neo4j.gds.core.utils.progress.tasks.LeafTask;
import org.neo4j.gds.core.utils.progress.tasks.Status;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskVisitor;

public class SubTaskCountingVisitor
implements TaskVisitor {
    private boolean containsUnresolvedOpenTask = false;
    private int numSubTasks = 0;
    private int numFinishedSubTasks = 0;

    int numSubTasks() {
        return this.numSubTasks;
    }

    int numFinishedSubTasks() {
        return this.numFinishedSubTasks;
    }

    boolean containsUnresolvedOpenTask() {
        return this.containsUnresolvedOpenTask;
    }

    void reset() {
        this.numSubTasks = 0;
        this.numFinishedSubTasks = 0;
        this.containsUnresolvedOpenTask = false;
    }

    public void visitLeafTask(LeafTask leafTask) {
        this.incrementCounters((Task)leafTask);
    }

    public void visitIntermediateTask(Task task) {
        this.incrementCounters(task);
        this.visitRecursively(task);
    }

    public void visitIterativeTask(IterativeTask iterativeTask) {
        this.incrementCounters((Task)iterativeTask);
        switch (iterativeTask.mode()) {
            case FIXED: 
            case DYNAMIC: {
                this.visitRecursively((Task)iterativeTask);
                break;
            }
            case OPEN: {
                if (iterativeTask.status() == Status.FINISHED) {
                    this.incrementCounters((Task)iterativeTask);
                    this.containsUnresolvedOpenTask = false;
                    break;
                }
                this.containsUnresolvedOpenTask = true;
            }
        }
    }

    private void visitRecursively(Task task) {
        task.subTasks().forEach(subTask -> subTask.visit((TaskVisitor)this));
    }

    private void incrementCounters(Task task) {
        ++this.numSubTasks;
        if (task.status() == Status.FINISHED) {
            ++this.numFinishedSubTasks;
        }
    }
}

