/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths;

import java.util.Optional;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.MutateComputationResultConsumer;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.MutateRelationshipConfig;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.paths.MutateResult;
import org.neo4j.gds.paths.dijkstra.DijkstraResult;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.values.storable.NumberType;

public class ShortestPathMutateResultConsumer<ALGO extends Algorithm<DijkstraResult>, CONFIG extends AlgoBaseConfig & MutateRelationshipConfig>
extends MutateComputationResultConsumer<ALGO, DijkstraResult, CONFIG, MutateResult> {
    public ShortestPathMutateResultConsumer() {
        super((computationResult, executionContext) -> new MutateResult.Builder().withPreProcessingMillis(computationResult.preProcessingMillis()).withComputeMillis(computationResult.computeMillis()).withConfig(computationResult.config()));
    }

    protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, ComputationResult<ALGO, DijkstraResult, CONFIG> computationResult, ExecutionContext executionContext) {
        Relationships relationships;
        AlgoBaseConfig config = computationResult.config();
        DijkstraResult result = (DijkstraResult)computationResult.result();
        RelationshipType mutateRelationshipType = RelationshipType.of((String)((MutateRelationshipConfig)config).mutateRelationshipType());
        RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().nodes((PartialIdMap)computationResult.graph()).addPropertyConfig(Aggregation.NONE, DefaultValue.forDouble()).orientation(Orientation.NATURAL).build();
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withMutateMillis(arg_0));){
            result.forEachPath(pathResult -> relationshipsBuilder.addFromInternal(pathResult.sourceNode(), pathResult.targetNode(), pathResult.totalCost()));
            relationships = relationshipsBuilder.build();
            resultBuilder.withRelationshipsWritten(relationships.topology().elementCount());
        }
        computationResult.graphStore().addRelationshipType(mutateRelationshipType, Optional.of("totalCost"), Optional.of(NumberType.FLOATING_POINT), relationships);
    }
}

