/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths;

import java.util.stream.Stream;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.paths.PathResult;
import org.neo4j.gds.paths.StreamResult;
import org.neo4j.gds.paths.dijkstra.DijkstraResult;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.Statement;

public final class ShortestPathStreamResultConsumer<ALGO extends Algorithm<DijkstraResult>, CONFIG extends AlgoBaseConfig>
implements ComputationResultConsumer<ALGO, DijkstraResult, CONFIG, Stream<StreamResult>> {
    public Stream<StreamResult> consume(ComputationResult<ALGO, DijkstraResult, CONFIG> computationResult, ExecutionContext executionContext) {
        Graph graph = computationResult.graph();
        if (computationResult.isGraphEmpty()) {
            graph.release();
            return Stream.empty();
        }
        boolean shouldReturnPath = executionContext.callContext().outputFields().anyMatch(field -> StringFormatting.toLowerCaseWithLocale((String)field).equals("path"));
        StreamResult.Builder resultBuilder = new StreamResult.Builder((IdMap)graph, (Transaction)executionContext.transaction().internalTransaction());
        Stream resultStream = ((DijkstraResult)computationResult.result()).mapPaths(path -> resultBuilder.build((PathResult)path, shouldReturnPath));
        try (Statement statement = executionContext.transaction().acquireStatement();){
            statement.registerCloseableResource((AutoCloseable)resultStream);
        }
        return resultStream;
    }
}

