/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths;

import java.util.stream.Stream;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.LoggingUtil;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.WriteRelationshipConfig;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.write.ImmutableRelationship;
import org.neo4j.gds.core.write.RelationshipStreamExporter;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.paths.PathResult;
import org.neo4j.gds.paths.WritePathOptionsConfig;
import org.neo4j.gds.paths.dijkstra.DijkstraResult;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.StandardWriteRelationshipsResult;
import org.neo4j.kernel.api.Statement;
import org.neo4j.logging.Log;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class ShortestPathWriteResultConsumer<ALGO extends Algorithm<DijkstraResult>, CONFIG extends AlgoBaseConfig & WriteRelationshipConfig>
implements ComputationResultConsumer<ALGO, DijkstraResult, CONFIG, Stream<StandardWriteRelationshipsResult>> {
    public Stream<StandardWriteRelationshipsResult> consume(ComputationResult<ALGO, DijkstraResult, CONFIG> computationResult, ExecutionContext executionContext) {
        return (Stream)LoggingUtil.runWithExceptionLogging((String)"Write relationships failed", (Log)executionContext.log(), () -> {
            AlgoBaseConfig config = computationResult.config();
            AbstractResultBuilder resultBuilder = new StandardWriteRelationshipsResult.Builder().withPreProcessingMillis(computationResult.preProcessingMillis()).withComputeMillis(computationResult.computeMillis()).withConfig(config);
            if (computationResult.isGraphEmpty()) {
                return Stream.of(new StandardWriteRelationshipsResult(computationResult.preProcessingMillis(), 0L, 0L, 0L, 0L, config.toMap()));
            }
            Algorithm algorithm = computationResult.algorithm();
            DijkstraResult result = (DijkstraResult)computationResult.result();
            String writeRelationshipType = ((WriteRelationshipConfig)config).writeRelationshipType();
            boolean writeNodeIds = ((WritePathOptionsConfig)config).writeNodeIds();
            boolean writeCosts = ((WritePathOptionsConfig)config).writeCosts();
            Graph graph = computationResult.graph();
            Stream relationshipStream = result.mapPaths(pathResult -> ImmutableRelationship.of((long)pathResult.sourceNode(), (long)pathResult.targetNode(), (Value[])this.createValues((IdMap)graph, (PathResult)pathResult, writeNodeIds, writeCosts)));
            TaskProgressTracker progressTracker = new TaskProgressTracker(RelationshipStreamExporter.baseTask((String)"Write shortest Paths"), executionContext.log(), 1, executionContext.taskRegistryFactory());
            try (Statement statement = executionContext.transaction().acquireStatement();){
                statement.registerCloseableResource((AutoCloseable)relationshipStream);
                RelationshipStreamExporter exporter = executionContext.relationshipStreamExporterBuilder().withIdMappingOperator(arg_0 -> ((Graph)computationResult.graph()).toOriginalNodeId(arg_0)).withRelationships(relationshipStream).withTerminationFlag(algorithm.getTerminationFlag()).withProgressTracker((ProgressTracker)progressTracker).build();
                try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((AbstractResultBuilder)resultBuilder).withWriteMillis(arg_0));){
                    resultBuilder.withRelationshipsWritten(exporter.write(writeRelationshipType, this.createKeys(writeNodeIds, writeCosts)));
                }
            }
            return Stream.of((StandardWriteRelationshipsResult)resultBuilder.build());
        });
    }

    private String[] createKeys(boolean writeNodeIds, boolean writeCosts) {
        if (writeNodeIds && writeCosts) {
            return new String[]{"totalCost", "nodeIds", "costs"};
        }
        if (writeNodeIds) {
            return new String[]{"totalCost", "nodeIds"};
        }
        if (writeCosts) {
            return new String[]{"totalCost", "costs"};
        }
        return new String[]{"totalCost"};
    }

    private Value[] createValues(IdMap idMap, PathResult pathResult, boolean writeNodeIds, boolean writeCosts) {
        if (writeNodeIds && writeCosts) {
            return new Value[]{Values.doubleValue((double)pathResult.totalCost()), Values.longArray((long[])this.toOriginalIds(idMap, pathResult.nodeIds())), Values.doubleArray((double[])pathResult.costs())};
        }
        if (writeNodeIds) {
            return new Value[]{Values.doubleValue((double)pathResult.totalCost()), Values.longArray((long[])this.toOriginalIds(idMap, pathResult.nodeIds()))};
        }
        if (writeCosts) {
            return new Value[]{Values.doubleValue((double)pathResult.totalCost()), Values.doubleArray((double[])pathResult.costs())};
        }
        return new Value[]{Values.doubleValue((double)pathResult.totalCost())};
    }

    private long[] toOriginalIds(IdMap idMap, long[] internalIds) {
        for (int i = 0; i < internalIds.length; ++i) {
            internalIds[i] = idMap.toOriginalNodeId(internalIds[i]);
        }
        return internalIds;
    }
}

