/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.paths.PathFactory;
import org.neo4j.gds.paths.PathResult;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;

public final class StreamResult {
    public static final String COST_PROPERTY_NAME = "cost";
    public long index;
    public long sourceNode;
    public long targetNode;
    public double totalCost;
    public List<Long> nodeIds;
    public List<Double> costs;
    public Path path;

    private StreamResult(long index, long sourceNode, long targetNode, double totalCost, List<Long> nodeIds, List<Double> costs, @Nullable Path path) {
        this.index = index;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.totalCost = totalCost;
        this.nodeIds = nodeIds;
        this.costs = costs;
        this.path = path;
    }

    public static class Builder {
        private final IdMap idMap;
        private final Transaction transaction;

        public Builder(IdMap idMap, Transaction transaction) {
            this.idMap = idMap;
            this.transaction = transaction;
        }

        public StreamResult build(PathResult pathResult, boolean createCypherPath) {
            long[] nodeIds = pathResult.nodeIds();
            double[] costs = pathResult.costs();
            long pathIndex = pathResult.index();
            RelationshipType relationshipType = RelationshipType.withName((String)StringFormatting.formatWithLocale((String)"PATH_%d", (Object[])new Object[]{pathIndex}));
            for (int i = 0; i < nodeIds.length; ++i) {
                nodeIds[i] = this.idMap.toOriginalNodeId(nodeIds[i]);
            }
            Path path = null;
            if (createCypherPath) {
                path = PathFactory.create((Transaction)this.transaction, (long[])nodeIds, (double[])costs, (RelationshipType)relationshipType, (String)StreamResult.COST_PROPERTY_NAME);
            }
            return new StreamResult(pathIndex, this.idMap.toOriginalNodeId(pathResult.sourceNode()), this.idMap.toOriginalNodeId(pathResult.targetNode()), pathResult.totalCost(), Arrays.stream(nodeIds).boxed().collect(Collectors.toCollection(() -> new ArrayList(nodeIds.length))), Arrays.stream(costs).boxed().collect(Collectors.toCollection(() -> new ArrayList(costs.length))), path);
        }
    }
}

