/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.singlesource.delta;

import java.util.stream.Stream;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.paths.ShortestPathStreamResultConsumer;
import org.neo4j.gds.paths.StreamResult;
import org.neo4j.gds.paths.delta.DeltaStepping;
import org.neo4j.gds.paths.delta.DeltaSteppingFactory;
import org.neo4j.gds.paths.delta.config.AllShortestPathsDeltaStreamConfig;
import org.neo4j.gds.paths.dijkstra.DijkstraResult;

@GdsCallable(name="gds.allShortestPaths.delta.stream", description="The Delta Stepping shortest path algorithm computes the shortest (weighted) path between one node and any other node in the graph. The computation is run multi-threaded", executionMode=ExecutionMode.STREAM)
public class AllShortestPathsDeltaStreamSpec
implements AlgorithmSpec<DeltaStepping, DijkstraResult, AllShortestPathsDeltaStreamConfig, Stream<StreamResult>, DeltaSteppingFactory<AllShortestPathsDeltaStreamConfig>> {
    public String name() {
        return "gds.allShortestPaths.delta.stream";
    }

    public DeltaSteppingFactory<AllShortestPathsDeltaStreamConfig> algorithmFactory() {
        return new DeltaSteppingFactory();
    }

    public NewConfigFunction<AllShortestPathsDeltaStreamConfig> newConfigFunction() {
        return (username, configuration) -> AllShortestPathsDeltaStreamConfig.of((CypherMapWrapper)configuration);
    }

    public ComputationResultConsumer<DeltaStepping, DijkstraResult, AllShortestPathsDeltaStreamConfig, Stream<StreamResult>> computationResultConsumer() {
        return new ShortestPathStreamResultConsumer<DeltaStepping, AllShortestPathsDeltaStreamConfig>();
    }
}

