/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.singlesource.delta;

import java.util.stream.Stream;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.paths.ShortestPathWriteResultConsumer;
import org.neo4j.gds.paths.delta.DeltaStepping;
import org.neo4j.gds.paths.delta.DeltaSteppingFactory;
import org.neo4j.gds.paths.delta.config.AllShortestPathsDeltaWriteConfig;
import org.neo4j.gds.paths.dijkstra.DijkstraResult;
import org.neo4j.gds.results.StandardWriteRelationshipsResult;

@GdsCallable(name="gds.allShortestPaths.delta.write", description="The Delta Stepping shortest path algorithm computes the shortest (weighted) path between one node and any other node in the graph. The computation is run multi-threaded", executionMode=ExecutionMode.WRITE_RELATIONSHIP)
public class AllShortestPathsDeltaWriteSpec
implements AlgorithmSpec<DeltaStepping, DijkstraResult, AllShortestPathsDeltaWriteConfig, Stream<StandardWriteRelationshipsResult>, DeltaSteppingFactory<AllShortestPathsDeltaWriteConfig>> {
    public String name() {
        return "gds.allShortestPaths.delta.write";
    }

    public DeltaSteppingFactory<AllShortestPathsDeltaWriteConfig> algorithmFactory() {
        return new DeltaSteppingFactory();
    }

    public NewConfigFunction<AllShortestPathsDeltaWriteConfig> newConfigFunction() {
        return (username, configuration) -> AllShortestPathsDeltaWriteConfig.of((CypherMapWrapper)configuration);
    }

    public ComputationResultConsumer<DeltaStepping, DijkstraResult, AllShortestPathsDeltaWriteConfig, Stream<StandardWriteRelationshipsResult>> computationResultConsumer() {
        return new ShortestPathWriteResultConsumer<DeltaStepping, AllShortestPathsDeltaWriteConfig>();
    }
}

