/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.singlesource.dijkstra;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutorSpec;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.executor.ProcedureExecutorSpec;
import org.neo4j.gds.paths.StreamResult;
import org.neo4j.gds.paths.singlesource.dijkstra.AllShortestPathsDijkstraStreamSpec;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class AllShortestPathsDijkstraStreamProc
extends BaseProc {
    @Procedure(name="gds.allShortestPaths.dijkstra.stream", mode=Mode.READ)
    @Description(value="The Dijkstra shortest path algorithm computes the shortest (weighted) path between one node and any other node in the graph.")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AllShortestPathsDijkstraStreamSpec deltaStreamSpec = new AllShortestPathsDijkstraStreamSpec();
        ProcedureExecutorSpec pipelineSpec = new ProcedureExecutorSpec();
        return (Stream)new ProcedureExecutor((AlgorithmSpec)deltaStreamSpec, (ExecutorSpec)pipelineSpec, this.executionContext()).compute(graphName, configuration, false, false);
    }

    @Procedure(name="gds.allShortestPaths.dijkstra.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        AllShortestPathsDijkstraStreamSpec deltaStreamSpec = new AllShortestPathsDijkstraStreamSpec();
        ProcedureExecutorSpec pipelineSpec = new ProcedureExecutorSpec();
        return new MemoryEstimationExecutor((AlgorithmSpec)deltaStreamSpec, (ExecutorSpec)pipelineSpec, this.executionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }
}

