/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.singlesource.dijkstra;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.write.RelationshipStreamExporter;
import org.neo4j.gds.core.write.RelationshipStreamExporterBuilder;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutorSpec;
import org.neo4j.gds.executor.ImmutableExecutionContext;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.executor.ProcedureExecutorSpec;
import org.neo4j.gds.paths.singlesource.dijkstra.AllShortestPathsDijkstraWriteSpec;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardWriteRelationshipsResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class AllShortestPathsDijkstraWriteProc
extends BaseProc {
    @Context
    public RelationshipStreamExporterBuilder<? extends RelationshipStreamExporter> relationshipStreamExporterBuilder;

    @Procedure(name="gds.allShortestPaths.dijkstra.write", mode=Mode.WRITE)
    @Description(value="The Dijkstra shortest path algorithm computes the shortest (weighted) path between one node and any other node in the graph.")
    public Stream<StandardWriteRelationshipsResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AllShortestPathsDijkstraWriteSpec writeSpec = new AllShortestPathsDijkstraWriteSpec();
        ProcedureExecutorSpec pipelineSpec = new ProcedureExecutorSpec();
        return (Stream)new ProcedureExecutor((AlgorithmSpec)writeSpec, (ExecutorSpec)pipelineSpec, this.executionContext()).compute(graphName, configuration, false, false);
    }

    @Procedure(name="gds.allShortestPaths.dijkstra.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        AllShortestPathsDijkstraWriteSpec writeSpec = new AllShortestPathsDijkstraWriteSpec();
        ProcedureExecutorSpec pipelineSpec = new ProcedureExecutorSpec();
        return new MemoryEstimationExecutor((AlgorithmSpec)writeSpec, (ExecutorSpec)pipelineSpec, this.executionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    public ExecutionContext executionContext() {
        return ImmutableExecutionContext.builder().api(this.api).log(this.log).procedureTransaction(this.procedureTransaction).transaction(this.transaction).callContext(this.callContext).userLogRegistryFactory(this.userLogRegistryFactory).taskRegistryFactory(this.taskRegistryFactory).username(this.username()).relationshipStreamExporterBuilder(this.relationshipStreamExporterBuilder).build();
    }
}

