/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.sourcetarget;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.paths.ShortestPathStreamProc;
import org.neo4j.gds.paths.StreamResult;
import org.neo4j.gds.paths.astar.AStar;
import org.neo4j.gds.paths.astar.AStarFactory;
import org.neo4j.gds.paths.astar.config.ShortestPathAStarStreamConfig;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.shortestPath.astar.stream", description="The A* shortest path algorithm computes the shortest path between a pair of nodes. It uses the relationship weight property to compare path lengths. In addition, this implementation uses the haversine distance as a heuristic to converge faster.", executionMode=ExecutionMode.STREAM)
public class ShortestPathAStarStreamProc
extends ShortestPathStreamProc<AStar, ShortestPathAStarStreamConfig> {
    @Procedure(name="gds.shortestPath.astar.stream", mode=Mode.READ)
    @Description(value="The A* shortest path algorithm computes the shortest path between a pair of nodes. It uses the relationship weight property to compare path lengths. In addition, this implementation uses the haversine distance as a heuristic to converge faster.")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphName, configuration, false, true));
    }

    @Procedure(name="gds.shortestPath.astar.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected ShortestPathAStarStreamConfig newConfig(String username, CypherMapWrapper config) {
        return ShortestPathAStarStreamConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<AStar, ShortestPathAStarStreamConfig> algorithmFactory() {
        return new AStarFactory();
    }
}

