/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.sourcetarget;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.paths.MutateResult;
import org.neo4j.gds.paths.ShortestPathMutateProc;
import org.neo4j.gds.paths.dijkstra.Dijkstra;
import org.neo4j.gds.paths.dijkstra.DijkstraFactory;
import org.neo4j.gds.paths.dijkstra.config.ShortestPathDijkstraMutateConfig;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.shortestPath.dijkstra.mutate", description="The Dijkstra shortest path algorithm computes the shortest (weighted) path between a pair of nodes.", executionMode=ExecutionMode.MUTATE_RELATIONSHIP)
public class ShortestPathDijkstraMutateProc
extends ShortestPathMutateProc<Dijkstra, ShortestPathDijkstraMutateConfig> {
    @Procedure(name="gds.shortestPath.dijkstra.mutate", mode=Mode.READ)
    @Description(value="The Dijkstra shortest path algorithm computes the shortest (weighted) path between a pair of nodes.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphName, configuration, false, true));
    }

    @Procedure(name="gds.shortestPath.dijkstra.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected ShortestPathDijkstraMutateConfig newConfig(String username, CypherMapWrapper config) {
        return ShortestPathDijkstraMutateConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<Dijkstra, ShortestPathDijkstraMutateConfig> algorithmFactory() {
        return new DijkstraFactory.SourceTargetDijkstraFactory();
    }
}

