/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.sourcetarget;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.paths.ShortestPathStreamProc;
import org.neo4j.gds.paths.StreamResult;
import org.neo4j.gds.paths.dijkstra.Dijkstra;
import org.neo4j.gds.paths.dijkstra.DijkstraFactory;
import org.neo4j.gds.paths.dijkstra.config.ShortestPathDijkstraStreamConfig;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.shortestPath.dijkstra.stream", description="The Dijkstra shortest path algorithm computes the shortest (weighted) path between a pair of nodes.", executionMode=ExecutionMode.STREAM)
public class ShortestPathDijkstraStreamProc
extends ShortestPathStreamProc<Dijkstra, ShortestPathDijkstraStreamConfig> {
    @Procedure(name="gds.shortestPath.dijkstra.stream", mode=Mode.READ)
    @Description(value="The Dijkstra shortest path algorithm computes the shortest (weighted) path between a pair of nodes.")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphName, configuration, false, true));
    }

    @Procedure(name="gds.shortestPath.dijkstra.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected ShortestPathDijkstraStreamConfig newConfig(String username, CypherMapWrapper config) {
        return ShortestPathDijkstraStreamConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<Dijkstra, ShortestPathDijkstraStreamConfig> algorithmFactory() {
        return new DijkstraFactory.SourceTargetDijkstraFactory();
    }
}

