/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.sourcetarget;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.paths.MutateResult;
import org.neo4j.gds.paths.ShortestPathMutateProc;
import org.neo4j.gds.paths.yens.Yens;
import org.neo4j.gds.paths.yens.YensFactory;
import org.neo4j.gds.paths.yens.config.ShortestPathYensMutateConfig;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.shortestPath.yens.mutate", description="The Yen's shortest path algorithm computes the k shortest (weighted) paths between a pair of nodes.", executionMode=ExecutionMode.MUTATE_RELATIONSHIP)
public class ShortestPathYensMutateProc
extends ShortestPathMutateProc<Yens, ShortestPathYensMutateConfig> {
    @Procedure(name="gds.shortestPath.yens.mutate", mode=Mode.READ)
    @Description(value="The Yen's shortest path algorithm computes the k shortest (weighted) paths between a pair of nodes.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphName, configuration, false, true));
    }

    @Procedure(name="gds.shortestPath.yens.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected ShortestPathYensMutateConfig newConfig(String username, CypherMapWrapper config) {
        return ShortestPathYensMutateConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<Yens, ShortestPathYensMutateConfig> algorithmFactory() {
        return new YensFactory();
    }
}

